/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.schema;

import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.GerritPersonIdent;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.git.LocalDiskRepositoryManager;
import com.google.gerrit.server.schema.SchemaVersion;
import com.google.gerrit.server.schema.Schema_105;
import com.google.gerrit.server.schema.UpdateUI;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;

public class Schema_106
extends SchemaVersion {
    private static final int THREADS_PER_CPU = 4;
    private final GitRepositoryManager repoManager;
    private final PersonIdent serverUser;

    @Inject
    Schema_106(Provider<Schema_105> prior, GitRepositoryManager repoManager, @GerritPersonIdent PersonIdent serverUser) {
        super(prior);
        this.repoManager = repoManager;
        this.serverUser = serverUser;
    }

    @Override
    protected void migrateData(ReviewDb db, UpdateUI ui) throws OrmException {
        if (!(this.repoManager instanceof LocalDiskRepositoryManager)) {
            return;
        }
        ui.message("listing all repositories ...");
        SortedSet<Project.NameKey> repoList = this.repoManager.list();
        ui.message("done");
        ui.message(String.format("creating reflog files for %s branches ...", "refs/meta/config"));
        ExecutorService executorPool = this.createExecutor(ui, repoList.size());
        ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>();
        for (Project.NameKey nameKey : repoList) {
            ReflogCreator callable = new ReflogCreator(nameKey);
            futures.add(executorPool.submit(callable));
        }
        executorPool.shutdown();
        try {
            for (Future future : futures) {
                try {
                    future.get();
                }
                catch (ExecutionException e) {
                    ui.message(e.getCause().getMessage());
                }
            }
            ui.message("done");
        }
        catch (InterruptedException ex) {
            String string = String.format("Migration step 106 was interrupted. Reflog created in %d of %d repositories only.", Schema_106.countDone(futures), repoList.size());
            ui.message(string);
        }
    }

    private static int countDone(List<Future<Void>> futures) {
        int count = 0;
        for (Future<Void> future : futures) {
            if (!future.isDone()) continue;
            ++count;
        }
        return count;
    }

    private ExecutorService createExecutor(UpdateUI ui, int repoCount) {
        int procs = Runtime.getRuntime().availableProcessors();
        int threads = Math.min(procs * 4, repoCount);
        ui.message(String.format("... using %d threads ...", threads));
        return Executors.newFixedThreadPool(threads);
    }

    private class ReflogCreator
    implements Callable<Void> {
        private final Project.NameKey project;

        ReflogCreator(Project.NameKey project) {
            this.project = project;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Void call() throws IOException {
            try (Repository repo = Schema_106.this.repoManager.openRepository(this.project);){
                File metaConfigLog = new File(repo.getDirectory(), "logs/refs/meta/config");
                if (metaConfigLog.exists()) {
                    Void void_ = null;
                    return void_;
                }
                if (!metaConfigLog.getParentFile().mkdirs()) throw new IOException();
                if (!metaConfigLog.createNewFile()) {
                    throw new IOException();
                }
                ObjectId metaConfigId = repo.resolve("refs/meta/config");
                if (metaConfigId != null) {
                    try (PrintWriter writer = new PrintWriter(metaConfigLog, StandardCharsets.UTF_8.name());){
                        writer.print(ObjectId.zeroId().name());
                        writer.print(" ");
                        writer.print(metaConfigId.name());
                        writer.print(" ");
                        writer.print(Schema_106.this.serverUser.toExternalString());
                        writer.print("\t");
                        writer.print("create reflog");
                        writer.println();
                    }
                }
                Void void_ = null;
                return void_;
            }
            catch (IOException e) {
                throw new IOException(String.format("ERROR: Failed to create reflog file for the %s branch in repository %s", "refs/meta/config", this.project.get()));
            }
        }
    }
}

