/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.schema;

import com.google.common.base.Strings;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.account.HashedPassword;
import com.google.gerrit.server.account.externalids.ExternalId;
import com.google.gerrit.server.schema.SchemaVersion;
import com.google.gerrit.server.schema.Schema_141;
import com.google.gerrit.server.schema.UpdateUI;
import com.google.gwtorm.jdbc.JdbcSchema;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class Schema_142
extends SchemaVersion {
    private static final int MAX_BATCH_SIZE = 1000;

    @Inject
    Schema_142(Provider<Schema_141> prior) {
        super(prior);
    }

    @Override
    protected void migrateData(ReviewDb db, UpdateUI ui) throws OrmException, SQLException {
        try (PreparedStatement updateStmt = ((JdbcSchema)((Object)db)).getConnection().prepareStatement("UPDATE account_external_ids SET password = ? WHERE external_id = ?");){
            int batchCount = 0;
            try (Statement stmt = Schema_142.newStatement(db);
                 ResultSet rs = stmt.executeQuery("SELECT external_id, password FROM account_external_ids");){
                while (rs.next()) {
                    String externalId = rs.getString("external_id");
                    String password = rs.getString("password");
                    if (!ExternalId.Key.parse(externalId).isScheme("username") || Strings.isNullOrEmpty(password)) continue;
                    HashedPassword hashed = HashedPassword.fromPassword(password);
                    updateStmt.setString(1, hashed.encode());
                    updateStmt.setString(2, externalId);
                    updateStmt.addBatch();
                    if (++batchCount < 1000) continue;
                    updateStmt.executeBatch();
                    batchCount = 0;
                }
            }
            if (batchCount > 0) {
                updateStmt.executeBatch();
            }
        }
    }
}

