/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.update;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.update.ChainedReceiveCommands;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevWalk;

public class RepoView {
    private final Repository repo;
    private final RevWalk rw;
    private final ObjectInserter inserter;
    private final ObjectInserter inserterWrapper;
    private final ChainedReceiveCommands commands;
    private final boolean closeRepo;

    RepoView(GitRepositoryManager repoManager, Project.NameKey project) throws IOException {
        this.repo = repoManager.openRepository(project);
        this.inserter = this.repo.newObjectInserter();
        this.inserterWrapper = new NonFlushingInserter(this.inserter);
        this.rw = new RevWalk(this.inserter.newReader());
        this.commands = new ChainedReceiveCommands(this.repo);
        this.closeRepo = true;
    }

    RepoView(Repository repo, RevWalk rw, ObjectInserter inserter) {
        Preconditions.checkArgument(rw.getObjectReader().getCreatedFromInserter() == inserter, "expected RevWalk %s to be created by ObjectInserter %s", (Object)rw, (Object)inserter);
        this.repo = Preconditions.checkNotNull(repo);
        this.rw = Preconditions.checkNotNull(rw);
        this.inserter = Preconditions.checkNotNull(inserter);
        this.inserterWrapper = new NonFlushingInserter(inserter);
        this.commands = new ChainedReceiveCommands(repo);
        this.closeRepo = false;
    }

    public Config getConfig() {
        return new Config(this.repo.getConfig());
    }

    public RevWalk getRevWalk() {
        return this.rw;
    }

    public Optional<ObjectId> getRef(String name) throws IOException {
        return this.getCommands().get(name);
    }

    public Map<String, ObjectId> getRefs(String prefix) throws IOException {
        HashMap<String, ObjectId> result = new HashMap<String, ObjectId>(Maps.transformValues(this.repo.getRefDatabase().getRefs(prefix), Ref::getObjectId));
        this.commands.getRepoRefCache().getCachedRefs().forEach((k, v) -> RepoView.updateRefIfPrefixMatches(result, prefix, k, v));
        this.commands.getCommands().values().forEach(c -> RepoView.updateRefIfPrefixMatches(result, prefix, c.getRefName(), RepoView.toOptional(c.getNewId())));
        return result;
    }

    private static Optional<ObjectId> toOptional(ObjectId id) {
        return id.equals(ObjectId.zeroId()) ? Optional.empty() : Optional.of(id);
    }

    private static void updateRefIfPrefixMatches(Map<String, ObjectId> map, String prefix, String fullRefName, Optional<ObjectId> maybeId) {
        if (!fullRefName.startsWith(prefix)) {
            return;
        }
        String suffix = fullRefName.substring(prefix.length());
        if (maybeId.isPresent()) {
            map.put(suffix, maybeId.get());
        } else {
            map.remove(suffix);
        }
    }

    void close() {
        if (this.closeRepo) {
            this.inserter.close();
            this.rw.close();
            this.repo.close();
        }
    }

    Repository getRepository() {
        return this.repo;
    }

    ObjectInserter getInserter() {
        return this.inserter;
    }

    ObjectInserter getInserterWrapper() {
        return this.inserterWrapper;
    }

    ChainedReceiveCommands getCommands() {
        return this.commands;
    }

    private static class NonFlushingInserter
    extends ObjectInserter.Filter {
        private final ObjectInserter delegate;

        private NonFlushingInserter(ObjectInserter delegate) {
            this.delegate = delegate;
        }

        @Override
        protected ObjectInserter delegate() {
            return this.delegate;
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() {
        }
    }
}

