/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.util;

import com.google.gerrit.common.data.Capable;
import com.google.gerrit.reviewdb.client.Project;
import java.io.IOException;
import java.util.Map;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MagicBranch {
    private static final Logger log = LoggerFactory.getLogger(MagicBranch.class);
    public static final String NEW_CHANGE = "refs/for/";
    public static final String NEW_DRAFT_CHANGE = "refs/drafts/";
    public static final String NEW_PUBLISH_CHANGE = "refs/publish/";

    public static String getDestBranchName(String refName) {
        String magicBranch = NEW_CHANGE;
        if (refName.startsWith(NEW_DRAFT_CHANGE)) {
            magicBranch = NEW_DRAFT_CHANGE;
        } else if (refName.startsWith(NEW_PUBLISH_CHANGE)) {
            magicBranch = NEW_PUBLISH_CHANGE;
        }
        return refName.substring(magicBranch.length());
    }

    public static boolean isMagicBranch(String refName) {
        return refName.startsWith(NEW_DRAFT_CHANGE) || refName.startsWith(NEW_PUBLISH_CHANGE) || refName.startsWith(NEW_CHANGE);
    }

    public static String getMagicRefNamePrefix(String refName) {
        if (refName.startsWith(NEW_DRAFT_CHANGE)) {
            return NEW_DRAFT_CHANGE;
        }
        if (refName.startsWith(NEW_PUBLISH_CHANGE)) {
            return NEW_PUBLISH_CHANGE;
        }
        if (refName.startsWith(NEW_CHANGE)) {
            return NEW_CHANGE;
        }
        return null;
    }

    public static Capable checkMagicBranchRefs(Repository repo, Project project) {
        Capable result = MagicBranch.checkMagicBranchRef(NEW_CHANGE, repo, project);
        if (result != Capable.OK) {
            return result;
        }
        result = MagicBranch.checkMagicBranchRef(NEW_DRAFT_CHANGE, repo, project);
        if (result != Capable.OK) {
            return result;
        }
        result = MagicBranch.checkMagicBranchRef(NEW_PUBLISH_CHANGE, repo, project);
        if (result != Capable.OK) {
            return result;
        }
        return Capable.OK;
    }

    private static Capable checkMagicBranchRef(String branchName, Repository repo, Project project) {
        Map<String, Ref> blockingFors;
        try {
            blockingFors = repo.getRefDatabase().getRefs(branchName);
        }
        catch (IOException err) {
            String projName = project.getName();
            log.warn("Cannot scan refs in '" + projName + "'", err);
            return new Capable("Server process cannot read '" + projName + "'");
        }
        if (!blockingFors.isEmpty()) {
            String projName = project.getName();
            log.error("Repository '" + projName + "' needs the following refs removed to receive changes: " + blockingFors.keySet());
            return new Capable("One or more " + branchName + " names blocks change upload");
        }
        return Capable.OK;
    }

    private MagicBranch() {
    }
}

