/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.util;

import com.google.common.base.Strings;
import com.google.gerrit.common.Die;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.config.SitePaths;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.apache.log4j.Appender;
import org.apache.log4j.AsyncAppender;
import org.apache.log4j.DailyRollingFileAppender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.LogManager;
import org.apache.log4j.helpers.OnlyOnceErrorHandler;
import org.apache.log4j.spi.ErrorHandler;
import org.apache.log4j.spi.LoggingEvent;
import org.eclipse.jgit.lib.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class SystemLog {
    private static final Logger log = LoggerFactory.getLogger(SystemLog.class);
    public static final String LOG4J_CONFIGURATION = "log4j.configuration";
    private final SitePaths site;
    private final int asyncLoggingBufferSize;
    private final boolean rotateLogs;

    @Inject
    public SystemLog(SitePaths site, @GerritServerConfig Config config) {
        this.site = site;
        this.asyncLoggingBufferSize = config.getInt("core", "asyncLoggingBufferSize", 64);
        this.rotateLogs = config.getBoolean("log", "rotate", true);
    }

    public static boolean shouldConfigure() {
        return Strings.isNullOrEmpty(System.getProperty(LOG4J_CONFIGURATION));
    }

    public static Appender createAppender(Path logdir, String name, Layout layout, boolean rotate) {
        FileAppender dst = rotate ? new DailyRollingFileAppender() : new FileAppender();
        dst.setName(name);
        dst.setLayout(layout);
        dst.setEncoding(StandardCharsets.UTF_8.name());
        dst.setFile(SystemLog.resolve(logdir).resolve(name).toString());
        dst.setImmediateFlush(true);
        dst.setAppend(true);
        dst.setErrorHandler(new DieErrorHandler());
        dst.activateOptions();
        dst.setErrorHandler(new OnlyOnceErrorHandler());
        return dst;
    }

    public AsyncAppender createAsyncAppender(String name, Layout layout) {
        return this.createAsyncAppender(name, layout, false);
    }

    public AsyncAppender createAsyncAppender(String name, Layout layout, boolean forPlugin) {
        return this.createAsyncAppender(name, layout, forPlugin, this.rotateLogs);
    }

    private AsyncAppender createAsyncAppender(String name, Layout layout, boolean forPlugin, boolean rotate) {
        AsyncAppender async = new AsyncAppender();
        async.setName(name);
        async.setBlocking(true);
        async.setBufferSize(this.asyncLoggingBufferSize);
        async.setLocationInfo(false);
        if (forPlugin || SystemLog.shouldConfigure()) {
            async.addAppender(SystemLog.createAppender(this.site.logs_dir, name, layout, rotate));
        } else {
            Appender appender = LogManager.getLogger(name).getAppender(name);
            if (appender != null) {
                async.addAppender(appender);
            } else {
                log.warn("No appender with the name: {} was found. {} logging is disabled", (Object)name, (Object)name);
            }
        }
        async.activateOptions();
        return async;
    }

    private static Path resolve(Path p) {
        try {
            return p.toRealPath(new LinkOption[0]).normalize();
        }
        catch (IOException e) {
            return p.toAbsolutePath().normalize();
        }
    }

    private static final class DieErrorHandler
    implements ErrorHandler {
        private DieErrorHandler() {
        }

        @Override
        public void error(String message, Exception e, int errorCode, LoggingEvent event) {
            this.error(e != null ? e.getMessage() : message);
        }

        @Override
        public void error(String message, Exception e, int errorCode) {
            this.error(e != null ? e.getMessage() : message);
        }

        @Override
        public void error(String message) {
            throw new Die("Cannot open log file: " + message);
        }

        @Override
        public void activateOptions() {
        }

        @Override
        public void setAppender(Appender appender) {
        }

        @Override
        public void setBackupAppender(Appender appender) {
        }

        @Override
        public void setLogger(org.apache.log4j.Logger logger) {
        }
    }
}

