/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.sshd.commands;

import com.google.common.base.Strings;
import com.google.gerrit.extensions.annotations.RequiresCapability;
import com.google.gerrit.extensions.common.PluginInfo;
import com.google.gerrit.extensions.restapi.TopLevelResource;
import com.google.gerrit.server.OutputFormat;
import com.google.gerrit.server.plugins.ListPlugins;
import com.google.gerrit.sshd.CommandMetaData;
import com.google.gerrit.sshd.SshCommand;
import com.google.gerrit.util.cli.Options;
import com.google.gson.reflect.TypeToken;
import com.google.inject.Inject;
import java.util.Map;
import java.util.SortedMap;
import org.kohsuke.args4j.Option;

@RequiresCapability(value="viewPlugins")
@CommandMetaData(name="ls", description="List the installed plugins", runsAt=CommandMetaData.Mode.MASTER_OR_SLAVE)
public class PluginLsCommand
extends SshCommand {
    @Inject
    @Options
    public ListPlugins list;
    @Option(name="--format", usage="output format")
    private OutputFormat format = OutputFormat.TEXT;

    @Override
    public void run() throws Exception {
        SortedMap<String, PluginInfo> output = this.list.apply(TopLevelResource.INSTANCE);
        if (this.format.isJson()) {
            this.format.newGson().toJson(output, new TypeToken<Map<String, PluginInfo>>(){}.getType(), this.stdout);
            this.stdout.print('\n');
        } else {
            this.stdout.format("%-30s %-10s %-8s %s\n", "Name", "Version", "Status", "File");
            this.stdout.print("-------------------------------------------------------------------------------\n");
            for (Map.Entry p : output.entrySet()) {
                PluginInfo info = (PluginInfo)p.getValue();
                this.stdout.format("%-30s %-10s %-8s %s\n", p.getKey(), Strings.nullToEmpty(info.version), this.status(info.disabled), Strings.nullToEmpty(info.filename));
            }
        }
        this.stdout.flush();
    }

    private String status(Boolean disabled) {
        return disabled != null && disabled != false ? "DISABLED" : "ENABLED";
    }
}

