/*
 * Decompiled with CFR 0.152.
 */
package com.google.gitiles.blame.cache;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.PersonIdent;

public class Region
implements Serializable,
Comparable<Region> {
    private static final long serialVersionUID = 1L;
    private final String sourcePath;
    private final ObjectId sourceCommit;
    private final PersonIdent sourceAuthor;
    private final int count;
    private transient int start;

    public Region(String path, ObjectId commit, PersonIdent author, int start, int end) {
        Preconditions.checkArgument(path != null && commit != null && author != null || path == null && commit == null && author == null, "expected all null or none: %s, %s, %s", (Object)path, (Object)commit, (Object)author);
        this.sourcePath = path;
        this.sourceCommit = commit;
        this.sourceAuthor = author;
        this.start = start;
        this.count = end - start;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public int getStart() {
        return this.start;
    }

    int getEnd() {
        return this.start + this.count;
    }

    public int getCount() {
        return this.count;
    }

    public String getSourcePath() {
        return this.sourcePath;
    }

    public ObjectId getSourceCommit() {
        return this.sourceCommit;
    }

    public PersonIdent getSourceAuthor() {
        return this.sourceAuthor;
    }

    @Override
    public int compareTo(Region o) {
        return this.start - o.start;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.sourceCommit != null) {
            sb.append(this.sourceCommit.name(), 0, 7).append(' ').append(this.sourceAuthor.toExternalString()).append(" (").append(this.sourcePath).append(')');
        } else {
            sb.append("<unblamed region>");
        }
        sb.append(' ').append("start=").append(this.start).append(", count=").append(this.count);
        return sb.toString();
    }
}

