/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.prolog_cafe.builtin;

import com.googlecode.prolog_cafe.exceptions.IllegalDomainException;
import com.googlecode.prolog_cafe.exceptions.IllegalTypeException;
import com.googlecode.prolog_cafe.exceptions.PInstantiationException;
import com.googlecode.prolog_cafe.lang.IntegerTerm;
import com.googlecode.prolog_cafe.lang.ListTerm;
import com.googlecode.prolog_cafe.lang.Operation;
import com.googlecode.prolog_cafe.lang.Predicate;
import com.googlecode.prolog_cafe.lang.Prolog;
import com.googlecode.prolog_cafe.lang.StructureTerm;
import com.googlecode.prolog_cafe.lang.Term;
import com.googlecode.prolog_cafe.lang.VariableTerm;

public class PRED_arg_3
extends Predicate.P3 {
    public PRED_arg_3(Term term, Term term2, Term term3, Operation operation) {
        this.arg1 = term;
        this.arg2 = term2;
        this.arg3 = term3;
        this.cont = operation;
    }

    @Override
    public Operation exec(Prolog prolog) {
        int n;
        Term[] termArray;
        prolog.setB0();
        Term term = this.arg1;
        Term term2 = this.arg2;
        Term term3 = this.arg3;
        term = term.dereference();
        if (term instanceof VariableTerm) {
            throw new PInstantiationException(this, 1);
        }
        if (!(term instanceof IntegerTerm)) {
            throw new IllegalTypeException(this, 1, "integer", term);
        }
        if ((term2 = term2.dereference()) instanceof ListTerm) {
            termArray = new Term[]{((ListTerm)term2).car(), ((ListTerm)term2).cdr()};
            n = 2;
        } else if (term2 instanceof StructureTerm) {
            termArray = ((StructureTerm)term2).args();
            n = ((StructureTerm)term2).arity();
        } else {
            if (term2 instanceof VariableTerm) {
                throw new PInstantiationException(this, 2);
            }
            throw new IllegalTypeException(this, 2, "compound", term2);
        }
        int n2 = ((IntegerTerm)term).intValue();
        if (n2 < 0) {
            throw new IllegalDomainException(this, 1, "not_less_than_zero", term);
        }
        if (n2 > n || n2 < 1) {
            return prolog.fail();
        }
        if (!term3.unify(termArray[n2 - 1], prolog.trail)) {
            return prolog.fail();
        }
        return this.cont;
    }
}

