/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.prolog_cafe.builtin;

import com.googlecode.prolog_cafe.exceptions.IllegalTypeException;
import com.googlecode.prolog_cafe.exceptions.PInstantiationException;
import com.googlecode.prolog_cafe.exceptions.RepresentationException;
import com.googlecode.prolog_cafe.lang.IntegerTerm;
import com.googlecode.prolog_cafe.lang.Operation;
import com.googlecode.prolog_cafe.lang.Predicate;
import com.googlecode.prolog_cafe.lang.Prolog;
import com.googlecode.prolog_cafe.lang.SymbolTerm;
import com.googlecode.prolog_cafe.lang.Term;
import com.googlecode.prolog_cafe.lang.VariableTerm;

public class PRED_char_code_2
extends Predicate.P2 {
    public PRED_char_code_2(Term term, Term term2, Operation operation) {
        this.arg1 = term;
        this.arg2 = term2;
        this.cont = operation;
    }

    @Override
    public Operation exec(Prolog prolog) {
        prolog.setB0();
        Term term = this.arg1;
        Term term2 = this.arg2;
        term = term.dereference();
        term2 = term2.dereference();
        if (term instanceof VariableTerm) {
            if (term2 instanceof VariableTerm) {
                throw new PInstantiationException(this, 2);
            }
            if (!(term2 instanceof IntegerTerm)) {
                throw new IllegalTypeException(this, 2, "integer", term2);
            }
            int n = ((IntegerTerm)term2).intValue();
            if (!Character.isDefined(n)) {
                throw new RepresentationException(this, 2, "character_code");
            }
            if (!term.unify(SymbolTerm.create((char)n), prolog.trail)) {
                return prolog.fail();
            }
        } else if (term instanceof SymbolTerm) {
            String string = ((SymbolTerm)term).name();
            if (string.length() != 1) {
                throw new IllegalTypeException(this, 1, "character", term);
            }
            if (!term2.unify(new IntegerTerm(string.charAt(0)), prolog.trail)) {
                return prolog.fail();
            }
        } else {
            return prolog.fail();
        }
        return this.cont;
    }
}

