/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.config.hosts;

import java.io.File;
import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.sshd.client.config.hosts.HostConfigEntry;
import org.apache.sshd.client.config.hosts.HostConfigEntryResolver;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.io.IoUtils;
import org.apache.sshd.common.util.io.ModifiableFileWatcher;

public class ConfigFileHostEntryResolver
extends ModifiableFileWatcher
implements HostConfigEntryResolver {
    private final AtomicReference<HostConfigEntryResolver> delegateHolder = new AtomicReference<HostConfigEntryResolver>(HostConfigEntryResolver.EMPTY);

    public ConfigFileHostEntryResolver(File file) {
        this(Objects.requireNonNull(file, "No file to watch").toPath());
    }

    public ConfigFileHostEntryResolver(Path file) {
        this(file, IoUtils.EMPTY_LINK_OPTIONS);
    }

    public ConfigFileHostEntryResolver(Path file, LinkOption ... options) {
        super(file, options);
    }

    @Override
    public HostConfigEntry resolveEffectiveHost(String host, int port, String username) throws IOException {
        try {
            HostConfigEntryResolver delegate = Objects.requireNonNull(this.resolveEffectiveResolver(host, port, username), "No delegate");
            HostConfigEntry entry = delegate.resolveEffectiveHost(host, port, username);
            if (this.log.isDebugEnabled()) {
                this.log.debug("resolveEffectiveHost({}@{}:{}) => {}", username, host, port, entry);
            }
            return entry;
        }
        catch (Throwable e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("resolveEffectiveHost({}@{}:{}) failed ({}) to resolve: {}", username, host, port, e.getClass().getSimpleName(), e.getMessage());
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace("resolveEffectiveHost(" + username + "@" + host + ":" + port + ") resolution failure details", e);
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException(e);
        }
    }

    protected HostConfigEntryResolver resolveEffectiveResolver(String host, int port, String username) throws IOException {
        if (this.checkReloadRequired()) {
            this.delegateHolder.set(HostConfigEntryResolver.EMPTY);
            Path path = this.getPath();
            if (this.exists()) {
                List<HostConfigEntry> entries = this.reloadHostConfigEntries(path, host, port, username);
                if (GenericUtils.size(entries) > 0) {
                    this.delegateHolder.set(HostConfigEntry.toHostConfigEntryResolver(entries));
                }
            } else {
                this.log.info("resolveEffectiveResolver({}@{}:{}) no configuration file at {}", username, host, port, path);
            }
        }
        return this.delegateHolder.get();
    }

    protected List<HostConfigEntry> reloadHostConfigEntries(Path path, String host, int port, String username) throws IOException {
        List<HostConfigEntry> entries = HostConfigEntry.readHostConfigEntries(path, new OpenOption[0]);
        this.log.info("resolveEffectiveResolver({}@{}:{}) loaded {} entries from {}", username, host, port, GenericUtils.size(entries), path);
        this.updateReloadAttributes();
        return entries;
    }
}

