/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.jaas;

import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginContext;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;
import org.apache.sshd.server.auth.password.PasswordAuthenticator;
import org.apache.sshd.server.session.ServerSession;

public class JaasPasswordAuthenticator
extends AbstractLoggingBean
implements PasswordAuthenticator {
    private String domain;

    public JaasPasswordAuthenticator() {
        this(null);
    }

    public JaasPasswordAuthenticator(String domain) {
        this.domain = domain;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    @Override
    public boolean authenticate(String username, String password, ServerSession session) {
        return this.authenticate(username, password);
    }

    public boolean authenticate(String username, String password) {
        try {
            Subject subject = new Subject();
            LoginContext loginContext = new LoginContext(this.domain, subject, callbacks -> {
                for (Callback callback : callbacks) {
                    if (callback instanceof NameCallback) {
                        ((NameCallback)callback).setName(username);
                        continue;
                    }
                    if (callback instanceof PasswordCallback) {
                        ((PasswordCallback)callback).setPassword(password.toCharArray());
                        continue;
                    }
                    throw new UnsupportedCallbackException(callback);
                }
            });
            loginContext.login();
            loginContext.logout();
            return true;
        }
        catch (Exception e) {
            this.log.error("Authentication failed with error", e);
            return false;
        }
    }
}

