/*
 * Decompiled with CFR 0.152.
 */
package com.github.parboiled1.grappa.matchers.trie;

import com.google.common.annotations.Beta;
import java.nio.CharBuffer;
import java.util.Arrays;
import javax.annotation.concurrent.Immutable;

@Immutable
@Beta
public final class TrieNode {
    private final boolean fullWord;
    private final char[] nextChars;
    private final TrieNode[] nextNodes;

    TrieNode(boolean fullWord, char[] nextChars, TrieNode[] nextNodes) {
        this.fullWord = fullWord;
        this.nextChars = nextChars;
        this.nextNodes = nextNodes;
    }

    public int search(String needle) {
        return this.doSearch(CharBuffer.wrap(needle), this.fullWord ? 0 : -1, 0);
    }

    public boolean hasNextChar(char c) {
        return Arrays.binarySearch(this.nextChars, c) >= 0;
    }

    private int doSearch(CharBuffer buffer, int matchedLength, int currentLength) {
        int nextLength;
        int n = nextLength = this.fullWord ? currentLength : matchedLength;
        if (!buffer.hasRemaining()) {
            return nextLength;
        }
        int index = Arrays.binarySearch(this.nextChars, buffer.get());
        return index < 0 ? nextLength : this.nextNodes[index].doSearch(buffer, nextLength, currentLength + 1);
    }
}

