/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.extensions.conditions;

import com.google.common.collect.Iterables;
import java.util.Collections;

public abstract class BooleanCondition {
    public static final BooleanCondition TRUE = new Value(true);
    public static final BooleanCondition FALSE = new Value(false);

    public static BooleanCondition valueOf(boolean a) {
        return a ? TRUE : FALSE;
    }

    public static BooleanCondition and(BooleanCondition a, BooleanCondition b) {
        return a == FALSE || b == FALSE ? FALSE : new And(a, b);
    }

    public static BooleanCondition and(boolean a, BooleanCondition b) {
        return BooleanCondition.and(BooleanCondition.valueOf(a), b);
    }

    public static BooleanCondition or(BooleanCondition a, BooleanCondition b) {
        return a == TRUE || b == TRUE ? TRUE : new Or(a, b);
    }

    public static BooleanCondition or(boolean a, BooleanCondition b) {
        return BooleanCondition.or(BooleanCondition.valueOf(a), b);
    }

    public static BooleanCondition not(BooleanCondition bc) {
        return bc == TRUE ? FALSE : (bc == FALSE ? TRUE : new Not(bc));
    }

    BooleanCondition() {
    }

    public abstract boolean value();

    public abstract <T> Iterable<T> children(Class<T> var1);

    static String maybeTrim(BooleanCondition cond, Class<? extends BooleanCondition> type) {
        String s = cond.toString();
        if (cond.getClass() == type && s.length() > 2 && s.charAt(0) == '(' && s.charAt(s.length() - 1) == ')') {
            s = s.substring(1, s.length() - 1);
        }
        return s;
    }

    private static final class Value
    extends BooleanCondition {
        private final boolean value;

        Value(boolean v) {
            this.value = v;
        }

        @Override
        public boolean value() {
            return this.value;
        }

        @Override
        public <T> Iterable<T> children(Class<T> type) {
            return Collections.emptyList();
        }

        public int hashCode() {
            return this.value ? 1 : 0;
        }

        public boolean equals(Object other) {
            return other instanceof Value ? this.value == ((Value)other).value : false;
        }

        public String toString() {
            return Boolean.toString(this.value);
        }
    }

    private static final class Not
    extends BooleanCondition {
        private final BooleanCondition cond;

        Not(BooleanCondition bc) {
            this.cond = bc;
        }

        @Override
        public boolean value() {
            return !this.cond.value();
        }

        @Override
        public <T> Iterable<T> children(Class<T> type) {
            return this.cond.children(type);
        }

        public int hashCode() {
            return this.cond.hashCode() * 31;
        }

        public boolean equals(Object other) {
            return other instanceof Not ? this.cond.equals(((Not)other).cond) : false;
        }

        public String toString() {
            return "!" + this.cond;
        }
    }

    private static final class Or
    extends BooleanCondition {
        private final BooleanCondition a;
        private final BooleanCondition b;

        Or(BooleanCondition a, BooleanCondition b) {
            this.a = a;
            this.b = b;
        }

        @Override
        public boolean value() {
            return this.a.value() || this.b.value();
        }

        @Override
        public <T> Iterable<T> children(Class<T> type) {
            return Iterables.concat(this.a.children(type), this.b.children(type));
        }

        public int hashCode() {
            return this.a.hashCode() * 31 + this.b.hashCode();
        }

        public boolean equals(Object other) {
            if (other instanceof Or) {
                Or o = (Or)other;
                return this.a.equals(o.a) && this.b.equals(o.b);
            }
            return false;
        }

        public String toString() {
            return "(" + Or.maybeTrim(this.a, this.getClass()) + " || " + Or.maybeTrim(this.a, this.getClass()) + ")";
        }
    }

    private static final class And
    extends BooleanCondition {
        private final BooleanCondition a;
        private final BooleanCondition b;

        And(BooleanCondition a, BooleanCondition b) {
            this.a = a;
            this.b = b;
        }

        @Override
        public boolean value() {
            return this.a.value() && this.b.value();
        }

        @Override
        public <T> Iterable<T> children(Class<T> type) {
            return Iterables.concat(this.a.children(type), this.b.children(type));
        }

        public int hashCode() {
            return this.a.hashCode() * 31 + this.b.hashCode();
        }

        public boolean equals(Object other) {
            if (other instanceof And) {
                And o = (And)other;
                return this.a.equals(o.a) && this.b.equals(o.b);
            }
            return false;
        }

        public String toString() {
            return "(" + And.maybeTrim(this.a, this.getClass()) + " && " + And.maybeTrim(this.a, this.getClass()) + ")";
        }
    }
}

