/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.metrics.proc;

import com.google.gerrit.metrics.proc.OperatingSystemMXBeanInterface;
import com.google.gerrit.metrics.proc.OperatingSystemMXBeanReflectionBased;
import com.google.gerrit.metrics.proc.OperatingSystemMXBeanUnixNative;
import com.sun.management.UnixOperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OperatingSystemMXBeanFactory {
    private static final Logger log = LoggerFactory.getLogger(OperatingSystemMXBeanFactory.class);

    OperatingSystemMXBeanFactory() {
    }

    static OperatingSystemMXBeanInterface create() {
        OperatingSystemMXBean sys = ManagementFactory.getOperatingSystemMXBean();
        if (sys instanceof UnixOperatingSystemMXBean) {
            return new OperatingSystemMXBeanUnixNative((UnixOperatingSystemMXBean)sys);
        }
        for (String name : Arrays.asList("com.sun.management.UnixOperatingSystemMXBean", "com.ibm.lang.management.UnixOperatingSystemMXBean")) {
            try {
                Class<?> impl = Class.forName(name);
                if (!impl.isInstance(sys)) continue;
                return new OperatingSystemMXBeanReflectionBased(sys);
            }
            catch (ReflectiveOperationException e) {
                log.debug("No implementation for {}", (Object)name, (Object)e);
            }
        }
        log.warn("No implementation of UnixOperatingSystemMXBean found");
        return null;
    }
}

