/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server;

import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.io.BaseEncoding;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.inject.Singleton;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.Comparator;
import java.util.Map;
import java.util.Random;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;

@Singleton
public class ChangeUtil {
    public static final int TOPIC_MAX_LENGTH = 2048;
    private static final Random UUID_RANDOM = new SecureRandom();
    private static final BaseEncoding UUID_ENCODING = BaseEncoding.base16().lowerCase();
    private static final int SUBJECT_MAX_LENGTH = 80;
    private static final String SUBJECT_CROP_APPENDIX = "...";
    private static final int SUBJECT_CROP_RANGE = 10;
    public static final Ordering<PatchSet> PS_ID_ORDER = Ordering.from(Comparator.comparingInt(PatchSet::getPatchSetId));

    public static String formatChangeUrl(String canonicalWebUrl, Change change) {
        return canonicalWebUrl + "#/c/" + change.getProject().get() + "/+/" + change.getChangeId();
    }

    public static String messageUuid() {
        byte[] buf = new byte[8];
        UUID_RANDOM.nextBytes(buf);
        return UUID_ENCODING.encode(buf, 0, 4) + '_' + UUID_ENCODING.encode(buf, 4, 4);
    }

    public static PatchSet.Id nextPatchSetIdFromAllRefsMap(Map<String, Ref> allRefs, PatchSet.Id id) {
        PatchSet.Id next = ChangeUtil.nextPatchSetId(id);
        while (allRefs.containsKey(next.toRefName())) {
            next = ChangeUtil.nextPatchSetId(next);
        }
        return next;
    }

    public static PatchSet.Id nextPatchSetIdFromChangeRefsMap(Map<String, ObjectId> changeRefs, PatchSet.Id id) {
        int prefixLen = id.getParentKey().toRefPrefix().length();
        PatchSet.Id next = ChangeUtil.nextPatchSetId(id);
        while (changeRefs.containsKey(next.toRefName().substring(prefixLen))) {
            next = ChangeUtil.nextPatchSetId(next);
        }
        return next;
    }

    public static PatchSet.Id nextPatchSetId(PatchSet.Id id) {
        return new PatchSet.Id(id.getParentKey(), id.get() + 1);
    }

    public static PatchSet.Id nextPatchSetId(Repository git, PatchSet.Id id) throws IOException {
        return ChangeUtil.nextPatchSetIdFromChangeRefsMap(Maps.transformValues(git.getRefDatabase().getRefs(id.getParentKey().toRefPrefix()), Ref::getObjectId), id);
    }

    public static String cropSubject(String subject) {
        if (subject.length() > 80) {
            int maxLength;
            for (int cropPosition = maxLength = 80 - SUBJECT_CROP_APPENDIX.length(); cropPosition > maxLength - 10; --cropPosition) {
                if (!Character.isWhitespace(subject.charAt(cropPosition - 1))) continue;
                return subject.substring(0, cropPosition) + SUBJECT_CROP_APPENDIX;
            }
            return subject.substring(0, maxLength) + SUBJECT_CROP_APPENDIX;
        }
        return subject;
    }

    public static String status(Change c) {
        return c != null ? c.getStatus().name().toLowerCase() : "deleted";
    }

    private ChangeUtil() {
    }
}

