/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.common.TimeUtil;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.RefNames;
import com.google.gerrit.server.git.MetaDataUpdate;
import com.google.gerrit.server.git.ValidationError;
import com.google.gerrit.server.git.VersionedMetaData;
import com.google.gerrit.server.mail.send.OutgoingEmailValidator;
import com.google.gwtorm.server.OrmDuplicateKeyException;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.lib.CommitBuilder;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevSort;

public class AccountConfig
extends VersionedMetaData
implements ValidationError.Sink {
    public static final String ACCOUNT_CONFIG = "account.config";
    public static final String ACCOUNT = "account";
    public static final String KEY_ACTIVE = "active";
    public static final String KEY_FULL_NAME = "fullName";
    public static final String KEY_PREFERRED_EMAIL = "preferredEmail";
    public static final String KEY_STATUS = "status";
    @Nullable
    private final OutgoingEmailValidator emailValidator;
    private final Account.Id accountId;
    private final String ref;
    private boolean isLoaded;
    private Account account;
    private Timestamp registeredOn;
    private List<ValidationError> validationErrors;

    public AccountConfig(@Nullable OutgoingEmailValidator emailValidator, Account.Id accountId) {
        this.emailValidator = emailValidator;
        this.accountId = accountId;
        this.ref = RefNames.refsUsers(accountId);
    }

    @Override
    protected String getRefName() {
        return this.ref;
    }

    public Account getAccount() {
        this.checkLoaded();
        return this.account;
    }

    public void setAccount(Account account) {
        this.checkLoaded();
        this.account = account;
        this.registeredOn = account.getRegisteredOn();
    }

    public Account getNewAccount() throws OrmDuplicateKeyException {
        this.checkLoaded();
        if (this.revision != null) {
            throw new OrmDuplicateKeyException(String.format("account %s already exists", this.accountId));
        }
        this.registeredOn = TimeUtil.nowTs();
        this.account = new Account(this.accountId, this.registeredOn);
        return this.account;
    }

    @Override
    protected void onLoad() throws IOException, ConfigInvalidException {
        if (this.revision != null) {
            this.rw.markStart(this.revision);
            this.rw.sort(RevSort.REVERSE);
            this.registeredOn = new Timestamp((long)this.rw.next().getCommitTime() * 1000L);
            Config cfg = this.readConfig(ACCOUNT_CONFIG);
            this.account = this.parse(cfg);
            this.account.setMetaId(this.revision.name());
        }
        this.isLoaded = true;
    }

    private Account parse(Config cfg) {
        Account account = new Account(this.accountId, this.registeredOn);
        account.setActive(cfg.getBoolean(ACCOUNT, null, KEY_ACTIVE, true));
        account.setFullName(AccountConfig.get(cfg, KEY_FULL_NAME));
        String preferredEmail = AccountConfig.get(cfg, KEY_PREFERRED_EMAIL);
        account.setPreferredEmail(preferredEmail);
        if (this.emailValidator != null && !this.emailValidator.isValid(preferredEmail)) {
            this.error(new ValidationError(ACCOUNT_CONFIG, String.format("Invalid preferred email: %s", preferredEmail)));
        }
        account.setStatus(AccountConfig.get(cfg, KEY_STATUS));
        return account;
    }

    @Override
    public RevCommit commit(MetaDataUpdate update) throws IOException {
        RevCommit c = super.commit(update);
        this.account.setMetaId(c.name());
        return c;
    }

    @Override
    protected boolean onSave(CommitBuilder commit) throws IOException, ConfigInvalidException {
        this.checkLoaded();
        if (this.revision != null) {
            commit.setMessage("Update account\n");
        } else if (this.account != null) {
            commit.setMessage("Create account\n");
            commit.setAuthor(new PersonIdent(commit.getAuthor(), this.registeredOn));
            commit.setCommitter(new PersonIdent(commit.getCommitter(), this.registeredOn));
        }
        Config cfg = this.readConfig(ACCOUNT_CONFIG);
        AccountConfig.writeToConfig(this.account, cfg);
        this.saveConfig(ACCOUNT_CONFIG, cfg);
        return true;
    }

    public static void writeToConfig(Account account, Config cfg) {
        AccountConfig.setActive(cfg, account.isActive());
        AccountConfig.set(cfg, KEY_FULL_NAME, account.getFullName());
        AccountConfig.set(cfg, KEY_PREFERRED_EMAIL, account.getPreferredEmail());
        AccountConfig.set(cfg, KEY_STATUS, account.getStatus());
    }

    private static void setActive(Config cfg, boolean value) {
        if (!value) {
            cfg.setBoolean(ACCOUNT, null, KEY_ACTIVE, false);
        } else {
            cfg.unset(ACCOUNT, null, KEY_ACTIVE);
        }
    }

    private static void set(Config cfg, String key, String value) {
        if (!Strings.isNullOrEmpty(value)) {
            cfg.setString(ACCOUNT, null, key, value);
        } else {
            cfg.unset(ACCOUNT, null, key);
        }
    }

    private static String get(Config cfg, String key) {
        return Strings.emptyToNull(cfg.getString(ACCOUNT, null, key));
    }

    private void checkLoaded() {
        Preconditions.checkState(this.isLoaded, "account not loaded yet");
    }

    public List<ValidationError> getValidationErrors() {
        if (this.validationErrors != null) {
            return ImmutableList.copyOf(this.validationErrors);
        }
        return ImmutableList.of();
    }

    @Override
    public void error(ValidationError error) {
        if (this.validationErrors == null) {
            this.validationErrors = new ArrayList<ValidationError>(4);
        }
        this.validationErrors.add(error);
    }
}

