/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account;

import com.google.gerrit.server.account.externalids.ExternalId;

public class AuthRequest {
    private ExternalId.Key externalId;
    private String password;
    private String displayName;
    private String emailAddress;
    private String userName;
    private boolean skipAuthentication;
    private String authPlugin;
    private String authProvider;
    private boolean authProvidesAccountActiveStatus;
    private boolean active;

    public static AuthRequest forUser(String username) {
        AuthRequest r = new AuthRequest(ExternalId.Key.create("gerrit", username));
        r.setUserName(username);
        return r;
    }

    public static AuthRequest forExternalUser(String username) {
        AuthRequest r = new AuthRequest(ExternalId.Key.create("external", username));
        r.setUserName(username);
        return r;
    }

    public static AuthRequest forEmail(String email) {
        AuthRequest r = new AuthRequest(ExternalId.Key.create("mailto", email));
        r.setEmailAddress(email);
        return r;
    }

    public AuthRequest(ExternalId.Key externalId) {
        this.externalId = externalId;
    }

    public ExternalId.Key getExternalIdKey() {
        return this.externalId;
    }

    public String getLocalUser() {
        if (this.externalId.isScheme("gerrit")) {
            return this.externalId.id();
        }
        return null;
    }

    public void setLocalUser(String localUser) {
        if (this.externalId.isScheme("gerrit")) {
            this.externalId = ExternalId.Key.create("gerrit", localUser);
        }
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String pass) {
        this.password = pass;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String name) {
        this.displayName = name != null && name.length() > 0 ? name : null;
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public void setEmailAddress(String email) {
        this.emailAddress = email != null && email.length() > 0 ? email : null;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String user) {
        this.userName = user;
    }

    public boolean isSkipAuthentication() {
        return this.skipAuthentication;
    }

    public void setSkipAuthentication(boolean skip) {
        this.skipAuthentication = skip;
    }

    public String getAuthPlugin() {
        return this.authPlugin;
    }

    public void setAuthPlugin(String authPlugin) {
        this.authPlugin = authPlugin;
    }

    public String getAuthProvider() {
        return this.authProvider;
    }

    public void setAuthProvider(String authProvider) {
        this.authProvider = authProvider;
    }

    public boolean authProvidesAccountActiveStatus() {
        return this.authProvidesAccountActiveStatus;
    }

    public void setAuthProvidesAccountActiveStatus(boolean authProvidesAccountActiveStatus) {
        this.authProvidesAccountActiveStatus = authProvidesAccountActiveStatus;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(Boolean isActive) {
        this.active = isActive;
    }
}

