/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account.externalids;

import com.google.common.collect.ImmutableSet;
import com.google.gerrit.server.GerritPersonIdent;
import com.google.gerrit.server.account.externalids.ExternalId;
import com.google.gerrit.server.account.externalids.ExternalIdCache;
import com.google.gerrit.server.account.externalids.ExternalIdReader;
import com.google.gerrit.server.account.externalids.ExternalIdsUpdate;
import com.google.gerrit.server.config.AllUsersName;
import com.google.gerrit.server.extensions.events.GitReferenceUpdated;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.notes.NoteMap;
import org.eclipse.jgit.revwalk.RevWalk;

public class ExternalIdsBatchUpdate {
    private final GitRepositoryManager repoManager;
    private final GitReferenceUpdated gitRefUpdated;
    private final AllUsersName allUsersName;
    private final PersonIdent serverIdent;
    private final ExternalIdCache externalIdCache;
    private final Set<ExternalId> toAdd = new HashSet<ExternalId>();
    private final Set<ExternalId> toDelete = new HashSet<ExternalId>();

    @Inject
    public ExternalIdsBatchUpdate(GitRepositoryManager repoManager, GitReferenceUpdated gitRefUpdated, AllUsersName allUsersName, @GerritPersonIdent PersonIdent serverIdent, ExternalIdCache externalIdCache) {
        this.repoManager = repoManager;
        this.gitRefUpdated = gitRefUpdated;
        this.allUsersName = allUsersName;
        this.serverIdent = serverIdent;
        this.externalIdCache = externalIdCache;
    }

    public void replace(ExternalId extIdToDelete, ExternalId extIdToAdd) {
        ExternalIdsUpdate.checkSameAccount(ImmutableSet.of(extIdToDelete, extIdToAdd));
        this.toAdd.add(extIdToAdd);
        this.toDelete.add(extIdToDelete);
    }

    public void commit(String commitMessage) throws IOException, OrmException, ConfigInvalidException {
        if (this.toDelete.isEmpty() && this.toAdd.isEmpty()) {
            return;
        }
        try (Repository repo = this.repoManager.openRepository(this.allUsersName);
             RevWalk rw = new RevWalk(repo);
             ObjectInserter ins = repo.newObjectInserter();){
            ObjectId rev = ExternalIdReader.readRevision(repo);
            NoteMap noteMap = ExternalIdReader.readNoteMap(rw, rev);
            for (ExternalId extId : this.toDelete) {
                ExternalIdsUpdate.remove(rw, noteMap, extId);
            }
            for (ExternalId extId : this.toAdd) {
                ExternalIdsUpdate.insert(rw, ins, noteMap, extId);
            }
            ObjectId newRev = ExternalIdsUpdate.commit(this.allUsersName, repo, rw, ins, rev, noteMap, commitMessage, this.serverIdent, this.serverIdent, null, this.gitRefUpdated);
            this.externalIdCache.onReplace(rev, newRev, this.toDelete, this.toAdd);
        }
        this.toAdd.clear();
        this.toDelete.clear();
    }
}

