/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.api.changes;

import com.google.gerrit.extensions.api.changes.RobotCommentApi;
import com.google.gerrit.extensions.common.RobotCommentInfo;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.server.api.ApiUtil;
import com.google.gerrit.server.change.GetRobotComment;
import com.google.gerrit.server.change.RobotCommentResource;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;

public class RobotCommentApiImpl
implements RobotCommentApi {
    private final GetRobotComment getComment;
    private final RobotCommentResource comment;

    @Inject
    RobotCommentApiImpl(GetRobotComment getComment, @Assisted RobotCommentResource comment) {
        this.getComment = getComment;
        this.comment = comment;
    }

    @Override
    public RobotCommentInfo get() throws RestApiException {
        try {
            return this.getComment.apply(this.comment);
        }
        catch (Exception e) {
            throw ApiUtil.asRestApiException("Cannot retrieve robot comment", e);
        }
    }

    static interface Factory {
        public RobotCommentApiImpl create(RobotCommentResource var1);
    }
}

