/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.api.projects;

import com.google.gerrit.extensions.api.changes.ChangeApi;
import com.google.gerrit.extensions.api.changes.Changes;
import com.google.gerrit.extensions.api.changes.CherryPickInput;
import com.google.gerrit.extensions.api.changes.IncludedInInfo;
import com.google.gerrit.extensions.api.projects.CommitApi;
import com.google.gerrit.extensions.common.ChangeInfo;
import com.google.gerrit.extensions.common.CommitInfo;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.server.api.ApiUtil;
import com.google.gerrit.server.change.CherryPickCommit;
import com.google.gerrit.server.project.CommitIncludedIn;
import com.google.gerrit.server.project.CommitResource;
import com.google.gerrit.server.project.GetCommit;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;

public class CommitApiImpl
implements CommitApi {
    private final Changes changes;
    private final GetCommit getCommit;
    private final CherryPickCommit cherryPickCommit;
    private final CommitIncludedIn includedIn;
    private final CommitResource commitResource;

    @Inject
    CommitApiImpl(Changes changes, GetCommit getCommit, CherryPickCommit cherryPickCommit, CommitIncludedIn includedIn, @Assisted CommitResource commitResource) {
        this.changes = changes;
        this.getCommit = getCommit;
        this.cherryPickCommit = cherryPickCommit;
        this.includedIn = includedIn;
        this.commitResource = commitResource;
    }

    @Override
    public CommitInfo get() throws RestApiException {
        try {
            return this.getCommit.apply(this.commitResource);
        }
        catch (Exception e) {
            throw ApiUtil.asRestApiException("Cannot get commit info", e);
        }
    }

    @Override
    public ChangeApi cherryPick(CherryPickInput input) throws RestApiException {
        try {
            return this.changes.id(((ChangeInfo)this.cherryPickCommit.apply(this.commitResource, input))._number);
        }
        catch (Exception e) {
            throw ApiUtil.asRestApiException("Cannot cherry pick", e);
        }
    }

    @Override
    public IncludedInInfo includedIn() throws RestApiException {
        try {
            return this.includedIn.apply(this.commitResource);
        }
        catch (Exception e) {
            throw ApiUtil.asRestApiException("Could not extract IncludedIn data", e);
        }
    }

    public static interface Factory {
        public CommitApiImpl create(CommitResource var1);
    }
}

