/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.args4j;

import com.google.gerrit.reviewdb.client.Branch;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gerrit.server.query.change.InternalChangeQuery;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.assistedinject.Assisted;
import java.util.Iterator;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.OptionDef;
import org.kohsuke.args4j.spi.OptionHandler;
import org.kohsuke.args4j.spi.Parameters;
import org.kohsuke.args4j.spi.Setter;

public class ChangeIdHandler
extends OptionHandler<Change.Id> {
    private final Provider<InternalChangeQuery> queryProvider;

    @Inject
    public ChangeIdHandler(Provider<InternalChangeQuery> queryProvider, @Assisted CmdLineParser parser, @Assisted OptionDef option, @Assisted Setter<Change.Id> setter) {
        super(parser, option, setter);
        this.queryProvider = queryProvider;
    }

    @Override
    public final int parseArguments(Parameters params) throws CmdLineException {
        String token = params.getParameter(0);
        String[] tokens = token.split(",");
        if (tokens.length != 3) {
            throw new CmdLineException(this.owner, "change should be specified as <project>,<branch>,<change-id>");
        }
        try {
            Change.Key key = Change.Key.parse(tokens[2]);
            Project.NameKey project = new Project.NameKey(tokens[0]);
            Branch.NameKey branch = new Branch.NameKey(project, tokens[1]);
            Iterator<ChangeData> iterator = this.queryProvider.get().byBranchKey(branch, key).iterator();
            if (iterator.hasNext()) {
                ChangeData cd = iterator.next();
                this.setter.addValue(cd.getId());
                return 1;
            }
        }
        catch (IllegalArgumentException e) {
            throw new CmdLineException(this.owner, "Change-Id is not valid");
        }
        catch (OrmException e) {
            throw new CmdLineException(this.owner, "Database error: " + e.getMessage());
        }
        throw new CmdLineException(this.owner, "\"" + token + "\": change not found");
    }

    @Override
    public final String getDefaultMetaVariable() {
        return "CHANGE";
    }
}

