/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.gerrit.common.FooterConstants;
import com.google.gerrit.common.data.LabelType;
import com.google.gerrit.common.data.LabelTypes;
import com.google.gerrit.extensions.api.changes.NotifyHandling;
import com.google.gerrit.extensions.api.changes.RecipientType;
import com.google.gerrit.extensions.restapi.ResourceConflictException;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.Branch;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.ChangeMessage;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.client.PatchSetInfo;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.ApprovalsUtil;
import com.google.gerrit.server.ChangeMessagesUtil;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.PatchSetUtil;
import com.google.gerrit.server.events.CommitReceivedEvent;
import com.google.gerrit.server.extensions.events.CommentAdded;
import com.google.gerrit.server.extensions.events.RevisionCreated;
import com.google.gerrit.server.git.GroupCollector;
import com.google.gerrit.server.git.SendEmailExecutor;
import com.google.gerrit.server.git.validators.CommitValidationException;
import com.google.gerrit.server.git.validators.CommitValidators;
import com.google.gerrit.server.mail.send.CreateChangeSender;
import com.google.gerrit.server.notedb.ChangeNotes;
import com.google.gerrit.server.notedb.ChangeUpdate;
import com.google.gerrit.server.notedb.NotesMigration;
import com.google.gerrit.server.notedb.ReviewerStateInternal;
import com.google.gerrit.server.patch.PatchSetInfoFactory;
import com.google.gerrit.server.permissions.ChangePermission;
import com.google.gerrit.server.permissions.PermissionBackend;
import com.google.gerrit.server.permissions.PermissionBackendException;
import com.google.gerrit.server.project.ProjectCache;
import com.google.gerrit.server.project.ProjectState;
import com.google.gerrit.server.ssh.NoSshInfo;
import com.google.gerrit.server.update.ChangeContext;
import com.google.gerrit.server.update.Context;
import com.google.gerrit.server.update.InsertChangeOp;
import com.google.gerrit.server.update.RepoContext;
import com.google.gerrit.server.util.RequestScopePropagator;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.ReceiveCommand;
import org.eclipse.jgit.util.ChangeIdUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangeInserter
implements InsertChangeOp {
    private static final Logger log = LoggerFactory.getLogger(ChangeInserter.class);
    private final PermissionBackend permissionBackend;
    private final ProjectCache projectCache;
    private final IdentifiedUser.GenericFactory userFactory;
    private final PatchSetInfoFactory patchSetInfoFactory;
    private final PatchSetUtil psUtil;
    private final ApprovalsUtil approvalsUtil;
    private final ChangeMessagesUtil cmUtil;
    private final CreateChangeSender.Factory createChangeSenderFactory;
    private final ExecutorService sendEmailExecutor;
    private final CommitValidators.Factory commitValidatorsFactory;
    private final RevisionCreated revisionCreated;
    private final CommentAdded commentAdded;
    private final NotesMigration migration;
    private final Change.Id changeId;
    private final PatchSet.Id psId;
    private final ObjectId commitId;
    private final String refName;
    private Change.Status status;
    private String topic;
    private String message;
    private String patchSetDescription;
    private boolean isPrivate;
    private boolean workInProgress;
    private List<String> groups = Collections.emptyList();
    private boolean validate = true;
    private NotifyHandling notify = NotifyHandling.ALL;
    private ListMultimap<RecipientType, Account.Id> accountsToNotify = ImmutableListMultimap.of();
    private Set<Account.Id> reviewers;
    private Set<Account.Id> extraCC;
    private Map<String, Short> approvals;
    private RequestScopePropagator requestScopePropagator;
    private boolean fireRevisionCreated;
    private boolean sendMail;
    private boolean updateRef;
    private Change.Id revertOf;
    private ReceiveCommand cmd;
    private Change change;
    private ChangeMessage changeMessage;
    private PatchSetInfo patchSetInfo;
    private PatchSet patchSet;
    private String pushCert;
    private ProjectState projectState;

    @Inject
    ChangeInserter(PermissionBackend permissionBackend, ProjectCache projectCache, IdentifiedUser.GenericFactory userFactory, PatchSetInfoFactory patchSetInfoFactory, PatchSetUtil psUtil, ApprovalsUtil approvalsUtil, ChangeMessagesUtil cmUtil, CreateChangeSender.Factory createChangeSenderFactory, @SendEmailExecutor ExecutorService sendEmailExecutor, CommitValidators.Factory commitValidatorsFactory, CommentAdded commentAdded, RevisionCreated revisionCreated, NotesMigration migration, @Assisted Change.Id changeId, @Assisted ObjectId commitId, @Assisted String refName) {
        this.permissionBackend = permissionBackend;
        this.projectCache = projectCache;
        this.userFactory = userFactory;
        this.patchSetInfoFactory = patchSetInfoFactory;
        this.psUtil = psUtil;
        this.approvalsUtil = approvalsUtil;
        this.cmUtil = cmUtil;
        this.createChangeSenderFactory = createChangeSenderFactory;
        this.sendEmailExecutor = sendEmailExecutor;
        this.commitValidatorsFactory = commitValidatorsFactory;
        this.revisionCreated = revisionCreated;
        this.commentAdded = commentAdded;
        this.migration = migration;
        this.changeId = changeId;
        this.psId = new PatchSet.Id(changeId, 1);
        this.commitId = commitId.copy();
        this.refName = refName;
        this.reviewers = Collections.emptySet();
        this.extraCC = Collections.emptySet();
        this.approvals = Collections.emptyMap();
        this.fireRevisionCreated = true;
        this.sendMail = true;
        this.updateRef = true;
    }

    @Override
    public Change createChange(Context ctx) throws IOException {
        this.change = new Change(ChangeInserter.getChangeKey(ctx.getRevWalk(), this.commitId), this.changeId, ctx.getAccountId(), new Branch.NameKey(ctx.getProject(), this.refName), ctx.getWhen());
        this.change.setStatus(MoreObjects.firstNonNull(this.status, Change.Status.NEW));
        this.change.setTopic(this.topic);
        this.change.setPrivate(this.isPrivate);
        this.change.setWorkInProgress(this.workInProgress);
        this.change.setReviewStarted(!this.workInProgress);
        this.change.setRevertOf(this.revertOf);
        return this.change;
    }

    private static Change.Key getChangeKey(RevWalk rw, ObjectId id) throws IOException {
        RevCommit commit = rw.parseCommit(id);
        rw.parseBody(commit);
        List<String> idList = commit.getFooterLines(FooterConstants.CHANGE_ID);
        if (!idList.isEmpty()) {
            return new Change.Key(idList.get(idList.size() - 1).trim());
        }
        ObjectId changeId = ChangeIdUtil.computeChangeId(commit.getTree(), commit, commit.getAuthorIdent(), commit.getCommitterIdent(), commit.getShortMessage());
        StringBuilder changeIdStr = new StringBuilder();
        changeIdStr.append("I").append(ObjectId.toString(changeId));
        return new Change.Key(changeIdStr.toString());
    }

    public PatchSet.Id getPatchSetId() {
        return this.psId;
    }

    public ObjectId getCommitId() {
        return this.commitId;
    }

    public Change getChange() {
        Preconditions.checkState(this.change != null, "getChange() only valid after creating change");
        return this.change;
    }

    public ChangeInserter setTopic(String topic) {
        Preconditions.checkState(this.change == null, "setTopic(String) only valid before creating change");
        this.topic = topic;
        return this;
    }

    public ChangeInserter setMessage(String message) {
        this.message = message;
        return this;
    }

    public ChangeInserter setPatchSetDescription(String patchSetDescription) {
        this.patchSetDescription = patchSetDescription;
        return this;
    }

    public ChangeInserter setValidate(boolean validate) {
        this.validate = validate;
        return this;
    }

    public ChangeInserter setNotify(NotifyHandling notify) {
        this.notify = notify;
        return this;
    }

    public ChangeInserter setAccountsToNotify(ListMultimap<RecipientType, Account.Id> accountsToNotify) {
        this.accountsToNotify = Preconditions.checkNotNull(accountsToNotify);
        return this;
    }

    public ChangeInserter setReviewers(Set<Account.Id> reviewers) {
        this.reviewers = reviewers;
        return this;
    }

    public ChangeInserter setExtraCC(Set<Account.Id> extraCC) {
        this.extraCC = extraCC;
        return this;
    }

    public ChangeInserter setPrivate(boolean isPrivate) {
        Preconditions.checkState(this.change == null, "setPrivate(boolean) only valid before creating change");
        this.isPrivate = isPrivate;
        return this;
    }

    public ChangeInserter setWorkInProgress(boolean workInProgress) {
        this.workInProgress = workInProgress;
        return this;
    }

    public ChangeInserter setStatus(Change.Status status) {
        Preconditions.checkState(this.change == null, "setStatus(Change.Status) only valid before creating change");
        this.status = status;
        return this;
    }

    public ChangeInserter setGroups(List<String> groups) {
        Preconditions.checkNotNull(groups, "groups may not be empty");
        Preconditions.checkState(this.patchSet == null, "setGroups(Iterable<String>) only valid before creating change");
        this.groups = groups;
        return this;
    }

    public ChangeInserter setFireRevisionCreated(boolean fireRevisionCreated) {
        this.fireRevisionCreated = fireRevisionCreated;
        return this;
    }

    public ChangeInserter setSendMail(boolean sendMail) {
        this.sendMail = sendMail;
        return this;
    }

    public ChangeInserter setRequestScopePropagator(RequestScopePropagator r) {
        this.requestScopePropagator = r;
        return this;
    }

    public ChangeInserter setRevertOf(Change.Id revertOf) {
        this.revertOf = revertOf;
        return this;
    }

    public void setPushCertificate(String cert) {
        this.pushCert = cert;
    }

    public PatchSet getPatchSet() {
        Preconditions.checkState(this.patchSet != null, "getPatchSet() only valid after creating change");
        return this.patchSet;
    }

    public ChangeInserter setApprovals(Map<String, Short> approvals) {
        this.approvals = approvals;
        return this;
    }

    @Deprecated
    public ChangeInserter setUpdateRef(boolean updateRef) {
        this.updateRef = updateRef;
        return this;
    }

    public ChangeMessage getChangeMessage() {
        if (this.message == null) {
            return null;
        }
        Preconditions.checkState(this.changeMessage != null, "getChangeMessage() only valid after inserting change");
        return this.changeMessage;
    }

    public ReceiveCommand getCommand() {
        return this.cmd;
    }

    @Override
    public void updateRepo(RepoContext ctx) throws ResourceConflictException, IOException {
        this.cmd = new ReceiveCommand(ObjectId.zeroId(), this.commitId, this.psId.toRefName());
        this.projectState = this.projectCache.checkedGet(ctx.getProject());
        this.validate(ctx);
        if (!this.updateRef) {
            return;
        }
        ctx.addRefUpdate(this.cmd);
    }

    @Override
    public boolean updateChange(ChangeContext ctx) throws RestApiException, OrmException, IOException, PermissionBackendException {
        List<String> newGroups;
        this.change = ctx.getChange();
        ReviewDb db = ctx.getDb();
        this.patchSetInfo = this.patchSetInfoFactory.get(ctx.getRevWalk(), ctx.getRevWalk().parseCommit(this.commitId), this.psId);
        ctx.getChange().setCurrentPatchSet(this.patchSetInfo);
        ChangeUpdate update = ctx.getUpdate(this.psId);
        update.setChangeId(this.change.getKey().get());
        update.setSubjectForCommit("Create change");
        update.setBranch(this.change.getDest().get());
        update.setTopic(this.change.getTopic());
        update.setPsDescription(this.patchSetDescription);
        update.setPrivate(this.isPrivate);
        update.setWorkInProgress(this.workInProgress);
        if (this.revertOf != null) {
            update.setRevertOf(this.revertOf.get());
        }
        if ((newGroups = this.groups).isEmpty()) {
            newGroups = GroupCollector.getDefaultGroups(this.commitId);
        }
        this.patchSet = this.psUtil.insert(ctx.getDb(), ctx.getRevWalk(), update, this.psId, this.commitId, newGroups, this.pushCert, this.patchSetDescription);
        update.fixStatus(this.change.getStatus());
        HashSet<Account.Id> reviewersToAdd = new HashSet<Account.Id>(this.reviewers);
        if (this.migration.readChanges()) {
            this.approvalsUtil.addCcs(ctx.getNotes(), update, this.filterOnChangeVisibility(db, ctx.getNotes(), this.extraCC));
        } else {
            reviewersToAdd.addAll(this.extraCC);
        }
        LabelTypes labelTypes = this.projectState.getLabelTypes();
        this.approvalsUtil.addReviewers(db, update, labelTypes, this.change, this.patchSet, this.patchSetInfo, this.filterOnChangeVisibility(db, ctx.getNotes(), reviewersToAdd), Collections.emptySet());
        this.approvalsUtil.addApprovalsForNewPatchSet(db, update, labelTypes, this.patchSet, ctx.getUser(), this.approvals);
        if (!this.approvals.isEmpty()) {
            update.putReviewer(ctx.getAccountId(), ReviewerStateInternal.REVIEWER);
        }
        if (this.message != null) {
            this.changeMessage = ChangeMessagesUtil.newMessage(this.patchSet.getId(), ctx.getUser(), this.patchSet.getCreatedOn(), this.message, ChangeMessagesUtil.uploadedPatchSetTag(this.workInProgress));
            this.cmUtil.addChangeMessage(db, update, this.changeMessage);
        }
        return true;
    }

    private Set<Account.Id> filterOnChangeVisibility(ReviewDb db, ChangeNotes notes, Set<Account.Id> accounts) {
        return accounts.stream().filter(accountId -> {
            try {
                IdentifiedUser user = this.userFactory.create((Account.Id)accountId);
                return ((PermissionBackend.ForChange)this.permissionBackend.user(user).change(notes).database(db)).test(ChangePermission.READ);
            }
            catch (PermissionBackendException e) {
                log.warn("Failed to check if account {} can see change {}", accountId.get(), notes.getChangeId().get(), e);
                return false;
            }
        }).collect(Collectors.toSet());
    }

    @Override
    public void postUpdate(Context ctx) throws OrmException, IOException {
        if (this.sendMail && (this.notify != NotifyHandling.NONE || !this.accountsToNotify.isEmpty())) {
            Runnable sender = new Runnable(){

                @Override
                public void run() {
                    try {
                        CreateChangeSender cm = ChangeInserter.this.createChangeSenderFactory.create(ChangeInserter.this.change.getProject(), ChangeInserter.this.change.getId());
                        cm.setFrom(ChangeInserter.this.change.getOwner());
                        cm.setPatchSet(ChangeInserter.this.patchSet, ChangeInserter.this.patchSetInfo);
                        cm.setNotify(ChangeInserter.this.notify);
                        cm.setAccountsToNotify(ChangeInserter.this.accountsToNotify);
                        cm.addReviewers(ChangeInserter.this.reviewers);
                        cm.addExtraCC(ChangeInserter.this.extraCC);
                        cm.send();
                    }
                    catch (Exception e) {
                        log.error("Cannot send email for new change {}", (Object)ChangeInserter.this.change.getId(), (Object)e);
                    }
                }

                public String toString() {
                    return "send-email newchange";
                }
            };
            if (this.requestScopePropagator != null) {
                Future<?> future = this.sendEmailExecutor.submit(this.requestScopePropagator.wrap(sender));
            } else {
                sender.run();
            }
        }
        if (this.fireRevisionCreated) {
            this.revisionCreated.fire(this.change, this.patchSet, ctx.getAccount(), ctx.getWhen(), this.notify);
            if (this.approvals != null && !this.approvals.isEmpty()) {
                List<LabelType> labels = this.projectState.getLabelTypes(this.change.getDest(), ctx.getUser()).getLabelTypes();
                HashMap<String, Short> allApprovals = new HashMap<String, Short>();
                HashMap<String, Short> oldApprovals = new HashMap<String, Short>();
                for (LabelType labelType : labels) {
                    allApprovals.put(labelType.getName(), (short)0);
                    oldApprovals.put(labelType.getName(), null);
                }
                for (Map.Entry entry : this.approvals.entrySet()) {
                    if ((Short)entry.getValue() == 0) continue;
                    allApprovals.put((String)entry.getKey(), (Short)entry.getValue());
                    oldApprovals.put((String)entry.getKey(), (short)0);
                }
                this.commentAdded.fire(this.change, this.patchSet, ctx.getAccount(), null, allApprovals, oldApprovals, ctx.getWhen());
            }
        }
    }

    private void validate(RepoContext ctx) throws IOException, ResourceConflictException {
        if (!this.validate) {
            return;
        }
        PermissionBackend.ForRef perm = this.permissionBackend.user(ctx.getUser()).project(ctx.getProject()).ref(this.refName);
        try (CommitReceivedEvent event = new CommitReceivedEvent(this.cmd, this.projectState.getProject(), this.change.getDest().get(), ctx.getRevWalk().getObjectReader(), this.commitId, ctx.getIdentifiedUser());){
            this.commitValidatorsFactory.forGerritCommits(perm, new Branch.NameKey(ctx.getProject(), this.refName), ctx.getIdentifiedUser(), new NoSshInfo(), ctx.getRevWalk()).validate(event);
        }
        catch (CommitValidationException e) {
            throw new ResourceConflictException(e.getFullMessage());
        }
    }

    public static interface Factory {
        public ChangeInserter create(Change.Id var1, ObjectId var2, String var3);
    }
}

