/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import com.google.gerrit.extensions.client.SubmitType;
import com.google.gerrit.extensions.common.ChangeInfo;
import com.google.gerrit.extensions.common.ChangeInput;
import com.google.gerrit.extensions.common.MergeInput;
import com.google.gerrit.extensions.restapi.BadRequestException;
import com.google.gerrit.extensions.restapi.Response;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.extensions.restapi.TopLevelResource;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.ChangeFinder;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.GerritPersonIdent;
import com.google.gerrit.server.PatchSetUtil;
import com.google.gerrit.server.Sequences;
import com.google.gerrit.server.account.AccountCache;
import com.google.gerrit.server.change.ChangeInserter;
import com.google.gerrit.server.change.ChangeJson;
import com.google.gerrit.server.change.NotifyUtil;
import com.google.gerrit.server.config.AnonymousCowardName;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.git.MergeUtil;
import com.google.gerrit.server.permissions.PermissionBackend;
import com.google.gerrit.server.permissions.PermissionBackendException;
import com.google.gerrit.server.project.CommitsCollection;
import com.google.gerrit.server.project.ContributorAgreementsChecker;
import com.google.gerrit.server.project.InvalidChangeOperationException;
import com.google.gerrit.server.project.ProjectState;
import com.google.gerrit.server.project.ProjectsCollection;
import com.google.gerrit.server.update.BatchUpdate;
import com.google.gerrit.server.update.RetryHelper;
import com.google.gerrit.server.update.RetryingRestModifyView;
import com.google.gerrit.server.update.UpdateException;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.TimeZone;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.lib.CommitBuilder;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.TreeFormatter;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;

@Singleton
public class CreateChange
extends RetryingRestModifyView<TopLevelResource, ChangeInput, Response<ChangeInfo>> {
    private final String anonymousCowardName;
    private final Provider<ReviewDb> db;
    private final GitRepositoryManager gitManager;
    private final AccountCache accountCache;
    private final Sequences seq;
    private final TimeZone serverTimeZone;
    private final PermissionBackend permissionBackend;
    private final Provider<CurrentUser> user;
    private final ProjectsCollection projectsCollection;
    private final CommitsCollection commits;
    private final ChangeInserter.Factory changeInserterFactory;
    private final ChangeJson.Factory jsonFactory;
    private final ChangeFinder changeFinder;
    private final PatchSetUtil psUtil;
    private final MergeUtil.Factory mergeUtilFactory;
    private final SubmitType submitType;
    private final NotifyUtil notifyUtil;
    private final ContributorAgreementsChecker contributorAgreements;
    private final boolean disablePrivateChanges;

    @Inject
    CreateChange(@AnonymousCowardName String anonymousCowardName, Provider<ReviewDb> db, GitRepositoryManager gitManager, AccountCache accountCache, Sequences seq, @GerritPersonIdent PersonIdent myIdent, PermissionBackend permissionBackend, Provider<CurrentUser> user, ProjectsCollection projectsCollection, CommitsCollection commits, ChangeInserter.Factory changeInserterFactory, ChangeJson.Factory json, ChangeFinder changeFinder, RetryHelper retryHelper, PatchSetUtil psUtil, @GerritServerConfig Config config, MergeUtil.Factory mergeUtilFactory, NotifyUtil notifyUtil, ContributorAgreementsChecker contributorAgreements) {
        super(retryHelper);
        this.anonymousCowardName = anonymousCowardName;
        this.db = db;
        this.gitManager = gitManager;
        this.accountCache = accountCache;
        this.seq = seq;
        this.serverTimeZone = myIdent.getTimeZone();
        this.permissionBackend = permissionBackend;
        this.user = user;
        this.projectsCollection = projectsCollection;
        this.commits = commits;
        this.changeInserterFactory = changeInserterFactory;
        this.jsonFactory = json;
        this.changeFinder = changeFinder;
        this.psUtil = psUtil;
        this.submitType = config.getEnum("project", null, "submitType", SubmitType.MERGE_IF_NECESSARY);
        this.disablePrivateChanges = config.getBoolean("change", null, "disablePrivateChanges", false);
        this.mergeUtilFactory = mergeUtilFactory;
        this.notifyUtil = notifyUtil;
        this.contributorAgreements = contributorAgreements;
    }

    /*
     * Exception decompiling
     */
    @Override
    protected Response<ChangeInfo> applyImpl(BatchUpdate.Factory updateFactory, TopLevelResource parent, ChangeInput input) throws OrmException, IOException, InvalidChangeOperationException, RestApiException, UpdateException, PermissionBackendException, ConfigInvalidException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 29[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static RevCommit newCommit(ObjectInserter oi, RevWalk rw, PersonIdent authorIdent, RevCommit mergeTip, String commitMessage) throws IOException {
        CommitBuilder commit = new CommitBuilder();
        if (mergeTip == null) {
            commit.setTreeId(CreateChange.emptyTreeId(oi));
        } else {
            commit.setTreeId(mergeTip.getTree().getId());
            commit.setParentId(mergeTip);
        }
        commit.setAuthor(authorIdent);
        commit.setCommitter(authorIdent);
        commit.setMessage(commitMessage);
        return rw.parseCommit(CreateChange.insert(oi, commit));
    }

    private RevCommit newMergeCommit(Repository repo, ObjectInserter oi, RevWalk rw, ProjectState projectState, RevCommit mergeTip, MergeInput merge, PersonIdent authorIdent, String commitMessage) throws RestApiException, IOException {
        if (Strings.isNullOrEmpty(merge.source)) {
            throw new BadRequestException("merge.source must be non-empty");
        }
        RevCommit sourceCommit = MergeUtil.resolveCommit(repo, rw, merge.source);
        if (!this.commits.canRead(projectState, repo, sourceCommit)) {
            throw new BadRequestException("do not have read permission for: " + merge.source);
        }
        MergeUtil mergeUtil = this.mergeUtilFactory.create(projectState);
        String mergeStrategy = MoreObjects.firstNonNull(Strings.emptyToNull(merge.strategy), mergeUtil.mergeStrategyName());
        return MergeUtil.createMergeCommit(oi, repo.getConfig(), mergeTip, sourceCommit, mergeStrategy, authorIdent, commitMessage, rw);
    }

    private static ObjectId insert(ObjectInserter inserter, CommitBuilder commit) throws IOException, UnsupportedEncodingException {
        ObjectId id = inserter.insert(commit);
        inserter.flush();
        return id;
    }

    private static ObjectId emptyTreeId(ObjectInserter inserter) throws IOException {
        return inserter.insert(new TreeFormatter());
    }

    private String clean(String msg) {
        return msg.replaceAll("(?m)^#.*$\n?", "").trim();
    }
}

