/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.gerrit.common.TimeUtil;
import com.google.gerrit.extensions.conditions.BooleanCondition;
import com.google.gerrit.extensions.restapi.MethodNotAllowedException;
import com.google.gerrit.extensions.restapi.Response;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.extensions.webui.UiAction;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.change.ChangeResource;
import com.google.gerrit.server.change.DeleteChangeOp;
import com.google.gerrit.server.permissions.ChangePermission;
import com.google.gerrit.server.permissions.PermissionBackend;
import com.google.gerrit.server.permissions.PermissionBackendException;
import com.google.gerrit.server.update.BatchUpdate;
import com.google.gerrit.server.update.Order;
import com.google.gerrit.server.update.RetryHelper;
import com.google.gerrit.server.update.RetryingRestModifyView;
import com.google.gerrit.server.update.UpdateException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;

@Singleton
public class DeleteChange
extends RetryingRestModifyView<ChangeResource, Input, Response<?>>
implements UiAction<ChangeResource> {
    private final Provider<ReviewDb> db;
    private final Provider<DeleteChangeOp> opProvider;

    @Inject
    public DeleteChange(Provider<ReviewDb> db, RetryHelper retryHelper, Provider<DeleteChangeOp> opProvider) {
        super(retryHelper);
        this.db = db;
        this.opProvider = opProvider;
    }

    @Override
    protected Response<?> applyImpl(BatchUpdate.Factory updateFactory, ChangeResource rsrc, Input input) throws RestApiException, UpdateException, PermissionBackendException {
        if (rsrc.getChange().getStatus() == Change.Status.MERGED) {
            throw new MethodNotAllowedException("delete not permitted");
        }
        ((PermissionBackend.ForChange)rsrc.permissions().database(this.db)).check(ChangePermission.DELETE);
        try (BatchUpdate bu = updateFactory.create(this.db.get(), rsrc.getProject(), rsrc.getUser(), TimeUtil.nowTs());){
            Change.Id id = rsrc.getChange().getId();
            bu.setOrder(Order.DB_BEFORE_REPO);
            bu.addOp(id, this.opProvider.get());
            bu.execute();
        }
        return Response.none();
    }

    @Override
    public UiAction.Description getDescription(ChangeResource rsrc) {
        Change.Status status = rsrc.getChange().getStatus();
        PermissionBackend.ForChange perm = (PermissionBackend.ForChange)rsrc.permissions().database(this.db);
        return new UiAction.Description().setLabel("Delete").setTitle("Delete change " + rsrc.getId()).setVisible(BooleanCondition.and(this.couldDeleteWhenIn(status), perm.testCond(ChangePermission.DELETE)));
    }

    private boolean couldDeleteWhenIn(Change.Status status) {
        switch (status) {
            case NEW: 
            case ABANDONED: {
                return true;
            }
            case MERGED: {
                return false;
            }
        }
        return false;
    }

    public static class Input {
    }
}

