/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.gerrit.extensions.registration.DynamicMap;
import com.google.gerrit.extensions.restapi.ChildCollection;
import com.google.gerrit.extensions.restapi.IdString;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.RestView;
import com.google.gerrit.reviewdb.client.FixSuggestion;
import com.google.gerrit.reviewdb.client.RobotComment;
import com.google.gerrit.server.CommentsUtil;
import com.google.gerrit.server.change.FixResource;
import com.google.gerrit.server.change.RevisionResource;
import com.google.gerrit.server.notedb.ChangeNotes;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.List;
import java.util.Objects;

@Singleton
public class Fixes
implements ChildCollection<RevisionResource, FixResource> {
    private final DynamicMap<RestView<FixResource>> views;
    private final CommentsUtil commentsUtil;

    @Inject
    Fixes(DynamicMap<RestView<FixResource>> views, CommentsUtil commentsUtil) {
        this.views = views;
        this.commentsUtil = commentsUtil;
    }

    @Override
    public RestView<RevisionResource> list() throws ResourceNotFoundException {
        throw new ResourceNotFoundException();
    }

    @Override
    public FixResource parse(RevisionResource revisionResource, IdString id) throws ResourceNotFoundException, OrmException {
        String fixId = id.get();
        ChangeNotes changeNotes = revisionResource.getNotes();
        List<RobotComment> robotComments = this.commentsUtil.robotCommentsByPatchSet(changeNotes, revisionResource.getPatchSet().getId());
        for (RobotComment robotComment : robotComments) {
            for (FixSuggestion fixSuggestion : robotComment.fixSuggestions) {
                if (!Objects.equals(fixId, fixSuggestion.fixId)) continue;
                return new FixResource(revisionResource, fixSuggestion.replacements);
            }
        }
        throw new ResourceNotFoundException(id);
    }

    @Override
    public DynamicMap<RestView<FixResource>> views() {
        return this.views;
    }
}

