/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.gerrit.common.data.SubmitTypeRecord;
import com.google.gerrit.extensions.client.SubmitType;
import com.google.gerrit.extensions.common.MergeableInfo;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.BadRequestException;
import com.google.gerrit.extensions.restapi.ResourceConflictException;
import com.google.gerrit.extensions.restapi.RestReadView;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.reviewdb.server.ReviewDbUtil;
import com.google.gerrit.server.ChangeUtil;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.change.MergeabilityCache;
import com.google.gerrit.server.change.RevisionResource;
import com.google.gerrit.server.git.BranchOrderSection;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.git.MergeUtil;
import com.google.gerrit.server.index.change.ChangeIndexer;
import com.google.gerrit.server.project.ProjectCache;
import com.google.gerrit.server.project.ProjectState;
import com.google.gerrit.server.project.SubmitRuleEvaluator;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.kohsuke.args4j.Option;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Mergeable
implements RestReadView<RevisionResource> {
    private static final Logger log = LoggerFactory.getLogger(Mergeable.class);
    @Option(name="--other-branches", aliases={"-o"}, usage="test mergeability for other branches too")
    private boolean otherBranches;
    private final GitRepositoryManager gitManager;
    private final ProjectCache projectCache;
    private final MergeUtil.Factory mergeUtilFactory;
    private final ChangeData.Factory changeDataFactory;
    private final Provider<ReviewDb> db;
    private final ChangeIndexer indexer;
    private final MergeabilityCache cache;
    private final SubmitRuleEvaluator.Factory submitRuleEvaluatorFactory;

    @Inject
    Mergeable(GitRepositoryManager gitManager, ProjectCache projectCache, MergeUtil.Factory mergeUtilFactory, ChangeData.Factory changeDataFactory, Provider<ReviewDb> db, ChangeIndexer indexer, MergeabilityCache cache, SubmitRuleEvaluator.Factory submitRuleEvaluatorFactory) {
        this.gitManager = gitManager;
        this.projectCache = projectCache;
        this.mergeUtilFactory = mergeUtilFactory;
        this.changeDataFactory = changeDataFactory;
        this.db = db;
        this.indexer = indexer;
        this.cache = cache;
        this.submitRuleEvaluatorFactory = submitRuleEvaluatorFactory;
    }

    public void setOtherBranches(boolean otherBranches) {
        this.otherBranches = otherBranches;
    }

    public MergeableInfo apply(RevisionResource resource) throws AuthException, ResourceConflictException, BadRequestException, OrmException, IOException {
        Change change = resource.getChange();
        PatchSet ps = resource.getPatchSet();
        MergeableInfo result = new MergeableInfo();
        if (!change.getStatus().isOpen()) {
            throw new ResourceConflictException("change is " + ChangeUtil.status(change));
        }
        if (!ps.getId().equals(change.currentPatchSetId())) {
            return result;
        }
        ChangeData cd = this.changeDataFactory.create(this.db.get(), resource.getNotes());
        result.submitType = this.getSubmitType(resource.getUser(), cd, ps);
        try (Repository git = this.gitManager.openRepository(change.getProject());){
            String strategy;
            ObjectId commit = Mergeable.toId(ps);
            Ref ref = git.getRefDatabase().exactRef(change.getDest().get());
            ProjectState projectState = this.projectCache.get(change.getProject());
            result.strategy = strategy = this.mergeUtilFactory.create(projectState).mergeStrategyName();
            result.mergeable = this.isMergable(git, change, commit, ref, result.submitType, strategy);
            if (this.otherBranches) {
                result.mergeableInto = new ArrayList<String>();
                BranchOrderSection branchOrder = projectState.getBranchOrderSection();
                if (branchOrder != null) {
                    int prefixLen = "refs/heads/".length();
                    String[] names = branchOrder.getMoreStable(ref.getName());
                    Map<String, Ref> refs = git.getRefDatabase().exactRef(names);
                    for (String n : names) {
                        Ref other = refs.get(n);
                        if (other == null || !this.cache.get(commit, other, SubmitType.CHERRY_PICK, strategy, change.getDest(), git)) continue;
                        result.mergeableInto.add(other.getName().substring(prefixLen));
                    }
                }
            }
        }
        return result;
    }

    private SubmitType getSubmitType(CurrentUser user, ChangeData cd, PatchSet patchSet) throws OrmException {
        SubmitTypeRecord rec = this.submitRuleEvaluatorFactory.create(user, cd).setPatchSet(patchSet).getSubmitType();
        if (rec.status != SubmitTypeRecord.Status.OK) {
            throw new OrmException("Submit type rule failed: " + rec);
        }
        return rec.type;
    }

    private boolean isMergable(Repository git, Change change, ObjectId commit, Ref ref, SubmitType submitType, String strategy) throws IOException, OrmException {
        if (commit == null) {
            return false;
        }
        Boolean old = this.cache.getIfPresent(commit, ref, submitType, strategy);
        if (old != null) {
            return old;
        }
        return this.refresh(change, commit, ref, submitType, strategy, git, old);
    }

    private static ObjectId toId(PatchSet ps) {
        try {
            return ObjectId.fromString(ps.getRevision().get());
        }
        catch (IllegalArgumentException e) {
            log.error("Invalid revision on patch set " + ps);
            return null;
        }
    }

    private boolean refresh(Change change, ObjectId commit, Ref ref, SubmitType type, String strategy, Repository git, Boolean old) throws OrmException, IOException {
        boolean mergeable = this.cache.get(commit, ref, type, strategy, change.getDest(), git);
        if (!Objects.equals(mergeable, old)) {
            Mergeable.invalidateETag(change.getId(), this.db.get());
            this.indexer.index(this.db.get(), change);
        }
        return mergeable;
    }

    private static void invalidateETag(Change.Id id, ReviewDb db) throws OrmException {
        Change c = (db = ReviewDbUtil.unwrapDb(db)).changes().get(id);
        if (c != null) {
            db.changes().update(Collections.singleton(c));
        }
    }
}

