/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.auto.value.AutoValue;
import com.google.common.primitives.Ints;
import com.google.gerrit.extensions.restapi.ResourceConflictException;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.extensions.restapi.UnprocessableEntityException;
import com.google.gerrit.reviewdb.client.Branch;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.client.RevId;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.PatchSetUtil;
import com.google.gerrit.server.change.AutoValue_RebaseUtil_Base;
import com.google.gerrit.server.change.RevisionResource;
import com.google.gerrit.server.notedb.ChangeNotes;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gerrit.server.query.change.InternalChangeQuery;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.IOException;
import java.io.Serializable;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RebaseUtil {
    private static final Logger log = LoggerFactory.getLogger(RebaseUtil.class);
    private final Provider<InternalChangeQuery> queryProvider;
    private final ChangeNotes.Factory notesFactory;
    private final Provider<ReviewDb> dbProvider;
    private final PatchSetUtil psUtil;

    @Inject
    RebaseUtil(Provider<InternalChangeQuery> queryProvider, ChangeNotes.Factory notesFactory, Provider<ReviewDb> dbProvider, PatchSetUtil psUtil) {
        this.queryProvider = queryProvider;
        this.notesFactory = notesFactory;
        this.dbProvider = dbProvider;
        this.psUtil = psUtil;
    }

    public boolean canRebase(PatchSet patchSet, Branch.NameKey dest, Repository git, RevWalk rw) {
        try {
            this.findBaseRevision(patchSet, dest, git, rw);
            return true;
        }
        catch (RestApiException e) {
            return false;
        }
        catch (OrmException | IOException e) {
            log.warn("Error checking if patch set {} on {} can be rebased", patchSet.getId(), dest, e);
            return false;
        }
    }

    Base parseBase(RevisionResource rsrc, String base) throws OrmException {
        Serializable baseChangeId;
        ChangeNotes baseNotes;
        ReviewDb db = this.dbProvider.get();
        PatchSet.Id basePatchSetId = PatchSet.Id.fromRef(base);
        if (basePatchSetId != null && (baseNotes = this.notesFor(rsrc, (Change.Id)(baseChangeId = basePatchSetId.getParentKey()))) != null) {
            return Base.create(this.notesFor(rsrc, basePatchSetId.getParentKey()), this.psUtil.get(db, baseNotes, basePatchSetId));
        }
        baseChangeId = Ints.tryParse(base);
        if (baseChangeId != null && (baseNotes = this.notesFor(rsrc, new Change.Id((Integer)baseChangeId))) != null) {
            return Base.create(baseNotes, this.psUtil.current(db, baseNotes));
        }
        Base ret = null;
        for (ChangeData cd : this.queryProvider.get().byProjectCommit(rsrc.getProject(), base)) {
            for (PatchSet ps : cd.patchSets()) {
                if (!ps.getRevision().matches(base) || ret != null && ret.patchSet().getId().get() >= ps.getId().get()) continue;
                ret = Base.create(cd.notes(), ps);
            }
        }
        return ret;
    }

    private ChangeNotes notesFor(RevisionResource rsrc, Change.Id id) throws OrmException {
        if (rsrc.getChange().getId().equals(id)) {
            return rsrc.getNotes();
        }
        return this.notesFactory.createChecked(this.dbProvider.get(), rsrc.getProject(), id);
    }

    ObjectId findBaseRevision(PatchSet patchSet, Branch.NameKey destBranch, Repository git, RevWalk rw) throws RestApiException, IOException, OrmException {
        String baseRev = null;
        RevCommit commit = rw.parseCommit(ObjectId.fromString(patchSet.getRevision().get()));
        if (commit.getParentCount() > 1) {
            throw new UnprocessableEntityException("Cannot rebase a change with multiple parents.");
        }
        if (commit.getParentCount() == 0) {
            throw new UnprocessableEntityException("Cannot rebase a change without any parents (is this the initial commit?).");
        }
        RevId parentRev = new RevId(commit.getParent(0).name());
        block0: for (ChangeData cd : this.queryProvider.get().byBranchCommit(destBranch, parentRev.get())) {
            for (PatchSet depPatchSet : cd.patchSets()) {
                if (!depPatchSet.getRevision().equals(parentRev)) continue;
                Change depChange = cd.change();
                if (depChange.getStatus() == Change.Status.ABANDONED) {
                    throw new ResourceConflictException("Cannot rebase a change with an abandoned parent: " + depChange.getKey());
                }
                if (!depChange.getStatus().isOpen()) break block0;
                if (depPatchSet.getId().equals(depChange.currentPatchSetId())) {
                    throw new ResourceConflictException("Change is already based on the latest patch set of the dependent change.");
                }
                baseRev = cd.currentPatchSet().getRevision().get();
                break block0;
            }
        }
        if (baseRev == null) {
            Ref destRef = git.getRefDatabase().exactRef(destBranch.get());
            if (destRef == null) {
                throw new UnprocessableEntityException("The destination branch does not exist: " + destBranch.get());
            }
            baseRev = destRef.getObjectId().getName();
            if (baseRev.equals(parentRev.get())) {
                throw new ResourceConflictException("Change is already up to date.");
            }
        }
        return ObjectId.fromString(baseRev);
    }

    @AutoValue
    static abstract class Base {
        Base() {
        }

        private static Base create(ChangeNotes notes, PatchSet ps) {
            if (notes == null) {
                return null;
            }
            return new AutoValue_RebaseUtil_Base(notes, ps);
        }

        abstract ChangeNotes notes();

        abstract PatchSet patchSet();
    }
}

