/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.common.base.Preconditions;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.extensions.restapi.RestResource;
import com.google.gerrit.extensions.restapi.RestView;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.change.ChangeResource;
import com.google.gerrit.server.change.RevisionResource;
import com.google.gerrit.server.mail.Address;
import com.google.inject.TypeLiteral;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;

public class ReviewerResource
implements RestResource {
    public static final TypeLiteral<RestView<ReviewerResource>> REVIEWER_KIND = new TypeLiteral<RestView<ReviewerResource>>(){};
    private final ChangeResource change;
    private final RevisionResource revision;
    @Nullable
    private final IdentifiedUser user;
    @Nullable
    private final Address address;

    @AssistedInject
    ReviewerResource(IdentifiedUser.GenericFactory userFactory, @Assisted ChangeResource change, @Assisted Account.Id id) {
        this.change = change;
        this.user = userFactory.create(id);
        this.revision = null;
        this.address = null;
    }

    @AssistedInject
    ReviewerResource(IdentifiedUser.GenericFactory userFactory, @Assisted RevisionResource revision, @Assisted Account.Id id) {
        this.revision = revision;
        this.change = revision.getChangeResource();
        this.user = userFactory.create(id);
        this.address = null;
    }

    ReviewerResource(ChangeResource change, Address address) {
        this.change = change;
        this.address = address;
        this.revision = null;
        this.user = null;
    }

    ReviewerResource(RevisionResource revision, Address address) {
        this.revision = revision;
        this.change = revision.getChangeResource();
        this.address = address;
        this.user = null;
    }

    public ChangeResource getChangeResource() {
        return this.change;
    }

    public RevisionResource getRevisionResource() {
        return this.revision;
    }

    public Change.Id getChangeId() {
        return this.change.getId();
    }

    public Change getChange() {
        return this.change.getChange();
    }

    public IdentifiedUser getReviewerUser() {
        Preconditions.checkArgument(this.user != null, "no user provided");
        return this.user;
    }

    public Address getReviewerByEmail() {
        Preconditions.checkArgument(this.address != null, "no address provided");
        return this.address;
    }

    public boolean isByEmail() {
        return this.user == null;
    }

    public static interface Factory {
        public ReviewerResource create(ChangeResource var1, Account.Id var2);

        public ReviewerResource create(RevisionResource var1, Account.Id var2);
    }
}

