/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.gerrit.extensions.restapi.Response;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.extensions.webui.UiAction;
import com.google.gerrit.server.StarredChangesUtil;
import com.google.gerrit.server.change.ChangeResource;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class Unignore
implements RestModifyView<ChangeResource, Input>,
UiAction<ChangeResource> {
    private static final Logger log = LoggerFactory.getLogger(Unignore.class);
    private final StarredChangesUtil stars;

    @Inject
    Unignore(StarredChangesUtil stars) {
        this.stars = stars;
    }

    @Override
    public UiAction.Description getDescription(ChangeResource rsrc) {
        return new UiAction.Description().setLabel("Unignore").setTitle("Unignore the change").setVisible(this.isIgnored(rsrc));
    }

    public Response<String> apply(ChangeResource rsrc, Input input) throws OrmException, StarredChangesUtil.IllegalLabelException {
        if (this.isIgnored(rsrc)) {
            this.stars.unignore(rsrc);
        }
        return Response.ok("");
    }

    private boolean isIgnored(ChangeResource rsrc) {
        try {
            return this.stars.isIgnored(rsrc);
        }
        catch (OrmException e) {
            log.error("failed to check ignored star", e);
            return false;
        }
    }

    public static class Input {
    }
}

