/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.config;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.gerrit.extensions.client.UiType;
import org.eclipse.jgit.lib.Config;

public class GerritOptions {
    private final boolean headless;
    private final boolean slave;
    private final boolean enablePolyGerrit;
    private final boolean enableGwtUi;
    private final boolean forcePolyGerritDev;
    private final UiType defaultUi;

    public GerritOptions(Config cfg, boolean headless, boolean slave, boolean forcePolyGerritDev) {
        this.slave = slave;
        this.enablePolyGerrit = forcePolyGerritDev || cfg.getBoolean("gerrit", null, "enablePolyGerrit", true);
        this.enableGwtUi = cfg.getBoolean("gerrit", null, "enableGwtUi", true);
        this.forcePolyGerritDev = forcePolyGerritDev;
        this.headless = headless || !this.enableGwtUi && !this.enablePolyGerrit;
        UiType defaultUi = this.enablePolyGerrit && !this.enableGwtUi ? UiType.POLYGERRIT : UiType.GWT;
        String uiStr = MoreObjects.firstNonNull(cfg.getString("gerrit", null, "ui"), defaultUi.name());
        this.defaultUi = MoreObjects.firstNonNull(UiType.parse(uiStr), UiType.NONE);
        switch (defaultUi) {
            case GWT: {
                Preconditions.checkArgument(this.enableGwtUi, "gerrit.ui = %s but GWT UI is disabled", (Object)defaultUi);
                break;
            }
            case POLYGERRIT: {
                Preconditions.checkArgument(this.enablePolyGerrit, "gerrit.ui = %s but PolyGerrit is disabled", (Object)defaultUi);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid gerrit.ui: " + uiStr);
            }
        }
    }

    public boolean headless() {
        return this.headless;
    }

    public boolean enableGwtUi() {
        return !this.headless && this.enableGwtUi;
    }

    public boolean enableMasterFeatures() {
        return !this.slave;
    }

    public boolean enablePolyGerrit() {
        return !this.headless && this.enablePolyGerrit;
    }

    public boolean forcePolyGerritDev() {
        return !this.headless && this.forcePolyGerritDev;
    }

    public UiType defaultUi() {
        return this.defaultUi;
    }
}

