/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.config;

import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.config.GitwebConfig;
import com.google.gerrit.server.config.SitePaths;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.eclipse.jgit.lib.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class GitwebCgiConfig {
    private static final Logger log = LoggerFactory.getLogger(GitwebCgiConfig.class);
    private final Path cgi;
    private final Path css;
    private final Path js;
    private final Path logoPng;

    public GitwebCgiConfig disabled() {
        return new GitwebCgiConfig();
    }

    @Inject
    GitwebCgiConfig(SitePaths sitePaths, @GerritServerConfig Config cfg) {
        Path cgi;
        if (GitwebConfig.isDisabled(cfg)) {
            this.cgi = null;
            this.css = null;
            this.js = null;
            this.logoPng = null;
            return;
        }
        String cfgCgi = cfg.getString("gitweb", null, "cgi");
        Path pkgCgi = Paths.get("/usr/lib/cgi-bin/gitweb.cgi", new String[0]);
        String[] resourcePaths = new String[]{"/usr/share/gitweb/static", "/usr/share/gitweb", "/var/www/static", "/var/www"};
        if (cfgCgi != null) {
            cgi = sitePaths.resolve(cfgCgi);
            if (!Files.isRegularFile(cgi, new LinkOption[0])) {
                throw new IllegalStateException("Cannot find gitweb.cgi: " + cgi);
            }
            if (!Files.isExecutable(cgi)) {
                throw new IllegalStateException("Cannot execute gitweb.cgi: " + cgi);
            }
            if (!cgi.equals(pkgCgi)) {
                String absPath = cgi.getParent().toAbsolutePath().toString();
                resourcePaths = new String[]{absPath + "/static", absPath};
            }
        } else if (cfg.getString("gitweb", null, "url") != null) {
            cgi = null;
            resourcePaths = new String[]{};
        } else if (Files.isRegularFile(pkgCgi, new LinkOption[0]) && Files.isExecutable(pkgCgi)) {
            log.debug("Assuming gitweb at " + pkgCgi);
            cgi = pkgCgi;
        } else {
            log.warn("gitweb not installed (no " + pkgCgi + " found)");
            cgi = null;
            resourcePaths = new String[]{};
        }
        Path css = null;
        Path js = null;
        Path logo = null;
        for (String path : resourcePaths) {
            Path dir = Paths.get(path, new String[0]);
            css = dir.resolve("gitweb.css");
            js = dir.resolve("gitweb.js");
            logo = dir.resolve("git-logo.png");
            if (Files.isRegularFile(css, new LinkOption[0]) && Files.isRegularFile(logo, new LinkOption[0])) break;
        }
        this.cgi = cgi;
        this.css = css;
        this.js = js;
        this.logoPng = logo;
    }

    private GitwebCgiConfig() {
        this.cgi = null;
        this.css = null;
        this.js = null;
        this.logoPng = null;
    }

    public Path getGitwebCgi() {
        return this.cgi;
    }

    public Path getGitwebCss() {
        return this.css;
    }

    public Path getGitwebJs() {
        return this.js;
    }

    public Path getGitLogoPng() {
        return this.logoPng;
    }
}

