/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.config;

import com.google.gerrit.server.securestore.SecureStore;
import org.eclipse.jgit.lib.Config;

public class GlobalPluginConfig
extends Config {
    private final SecureStore secureStore;
    private final String pluginName;

    GlobalPluginConfig(String pluginName, Config baseConfig, SecureStore secureStore) {
        super(baseConfig);
        this.pluginName = pluginName;
        this.secureStore = secureStore;
    }

    @Override
    public String getString(String section, String subsection, String name) {
        String secure = this.secureStore.getForPlugin(this.pluginName, section, subsection, name);
        if (secure != null) {
            return secure;
        }
        return super.getString(section, subsection, name);
    }

    @Override
    public String[] getStringList(String section, String subsection, String name) {
        String[] secure = this.secureStore.getListForPlugin(this.pluginName, section, subsection, name);
        if (secure != null && secure.length > 0) {
            return secure;
        }
        return super.getStringList(section, subsection, name);
    }
}

