/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.git;

import com.google.auto.value.AutoValue;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.gerrit.common.data.LabelType;
import com.google.gerrit.common.data.LabelTypes;
import com.google.gerrit.common.data.LabelValue;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.PatchSetApproval;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.git.AutoValue_LabelNormalizer_Result;
import com.google.gerrit.server.notedb.ChangeNotes;
import com.google.gerrit.server.project.ProjectCache;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

@Singleton
public class LabelNormalizer {
    private final IdentifiedUser.GenericFactory userFactory;
    private final ProjectCache projectCache;

    @Inject
    LabelNormalizer(IdentifiedUser.GenericFactory userFactory, ProjectCache projectCache) {
        this.userFactory = userFactory;
        this.projectCache = projectCache;
    }

    public Result normalize(ChangeNotes notes, Collection<PatchSetApproval> approvals) throws OrmException, IOException {
        IdentifiedUser user = this.userFactory.create(notes.getChange().getOwner());
        return this.normalize(notes, user, approvals);
    }

    public Result normalize(ChangeNotes notes, CurrentUser user, Collection<PatchSetApproval> approvals) throws IOException {
        ArrayList<PatchSetApproval> unchanged = Lists.newArrayListWithCapacity(approvals.size());
        ArrayList<PatchSetApproval> updated = Lists.newArrayListWithCapacity(approvals.size());
        ArrayList<PatchSetApproval> deleted = Lists.newArrayListWithCapacity(approvals.size());
        LabelTypes labelTypes = this.projectCache.checkedGet(notes.getProjectName()).getLabelTypes(notes, user);
        for (PatchSetApproval psa : approvals) {
            Change.Id changeId = psa.getKey().getParentKey().getParentKey();
            Preconditions.checkArgument(changeId.equals(notes.getChangeId()), "Approval %s does not match change %s", (Object)psa.getKey(), (Object)notes.getChange().getKey());
            if (psa.isLegacySubmit()) {
                unchanged.add(psa);
                continue;
            }
            LabelType label = labelTypes.byLabel(psa.getLabelId());
            if (label == null) {
                deleted.add(psa);
                continue;
            }
            PatchSetApproval copy = this.copy(psa);
            this.applyTypeFloor(label, copy);
            if (copy.getValue() != psa.getValue()) {
                updated.add(copy);
                continue;
            }
            unchanged.add(psa);
        }
        return Result.create(unchanged, updated, deleted);
    }

    private PatchSetApproval copy(PatchSetApproval src) {
        return new PatchSetApproval(src.getPatchSetId(), src);
    }

    private void applyTypeFloor(LabelType lt, PatchSetApproval a) {
        LabelValue atMax;
        LabelValue atMin = lt.getMin();
        if (atMin != null && a.getValue() < atMin.getValue()) {
            a.setValue(atMin.getValue());
        }
        if ((atMax = lt.getMax()) != null && a.getValue() > atMax.getValue()) {
            a.setValue(atMax.getValue());
        }
    }

    @AutoValue
    public static abstract class Result {
        @VisibleForTesting
        static Result create(List<PatchSetApproval> unchanged, List<PatchSetApproval> updated, List<PatchSetApproval> deleted) {
            return new AutoValue_LabelNormalizer_Result(ImmutableList.copyOf(unchanged), ImmutableList.copyOf(updated), ImmutableList.copyOf(deleted));
        }

        public abstract ImmutableList<PatchSetApproval> unchanged();

        public abstract ImmutableList<PatchSetApproval> updated();

        public abstract ImmutableList<PatchSetApproval> deleted();

        public Iterable<PatchSetApproval> getNormalized() {
            return Iterables.concat(this.unchanged(), this.updated());
        }
    }
}

