/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.git;

import com.google.gerrit.common.Nullable;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.GerritPersonIdent;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.extensions.events.GitReferenceUpdated;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.assistedinject.Assisted;
import java.io.IOException;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.eclipse.jgit.lib.BatchRefUpdate;
import org.eclipse.jgit.lib.CommitBuilder;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;

public class MetaDataUpdate
implements AutoCloseable {
    private final GitReferenceUpdated gitRefUpdated;
    private final Project.NameKey projectName;
    private final Repository repository;
    private final BatchRefUpdate batch;
    private final CommitBuilder commit;
    private boolean allowEmpty;
    private boolean insertChangeId;
    private boolean closeRepository;
    private IdentifiedUser author;

    @Inject
    public MetaDataUpdate(GitReferenceUpdated gitRefUpdated, @Assisted Project.NameKey projectName, @Assisted Repository repository, @Assisted @Nullable BatchRefUpdate batch) {
        this.gitRefUpdated = gitRefUpdated;
        this.projectName = projectName;
        this.repository = repository;
        this.batch = batch;
        this.commit = new CommitBuilder();
    }

    public MetaDataUpdate(GitReferenceUpdated gitRefUpdated, Project.NameKey projectName, Repository repository) {
        this(gitRefUpdated, projectName, repository, null);
    }

    public void setMessage(String message) {
        this.getCommitBuilder().setMessage(message);
    }

    public void setAuthor(IdentifiedUser author) {
        this.author = author;
        this.getCommitBuilder().setAuthor(author.newCommitterIdent(this.getCommitBuilder().getCommitter().getWhen(), this.getCommitBuilder().getCommitter().getTimeZone()));
    }

    public void setAllowEmpty(boolean allowEmpty) {
        this.allowEmpty = allowEmpty;
    }

    public void setInsertChangeId(boolean insertChangeId) {
        this.insertChangeId = insertChangeId;
    }

    public void setCloseRepository(boolean closeRepository) {
        this.closeRepository = closeRepository;
    }

    BatchRefUpdate getBatch() {
        return this.batch;
    }

    @Override
    public void close() {
        if (this.closeRepository) {
            this.getRepository().close();
        }
    }

    Project.NameKey getProjectName() {
        return this.projectName;
    }

    public Repository getRepository() {
        return this.repository;
    }

    boolean allowEmpty() {
        return this.allowEmpty;
    }

    boolean insertChangeId() {
        return this.insertChangeId;
    }

    public CommitBuilder getCommitBuilder() {
        return this.commit;
    }

    protected void fireGitRefUpdatedEvent(RefUpdate ru) {
        this.gitRefUpdated.fire(this.projectName, ru, this.author == null ? null : this.author.getAccount());
    }

    public static interface InternalFactory {
        public MetaDataUpdate create(@Assisted Project.NameKey var1, @Assisted Repository var2, @Assisted @Nullable BatchRefUpdate var3);
    }

    public static class Server {
        private final InternalFactory factory;
        private final GitRepositoryManager mgr;
        private final PersonIdent serverIdent;

        @Inject
        Server(InternalFactory factory, GitRepositoryManager mgr, @GerritPersonIdent PersonIdent serverIdent) {
            this.factory = factory;
            this.mgr = mgr;
            this.serverIdent = serverIdent;
        }

        public MetaDataUpdate create(Project.NameKey name) throws RepositoryNotFoundException, IOException {
            return this.create(name, null);
        }

        public MetaDataUpdate create(Project.NameKey name, BatchRefUpdate batch) throws RepositoryNotFoundException, IOException {
            Repository repo = this.mgr.openRepository(name);
            MetaDataUpdate md = this.factory.create(name, repo, batch);
            md.setCloseRepository(true);
            md.getCommitBuilder().setAuthor(this.serverIdent);
            md.getCommitBuilder().setCommitter(this.serverIdent);
            return md;
        }
    }

    public static class User {
        private final InternalFactory factory;
        private final GitRepositoryManager mgr;
        private final PersonIdent serverIdent;
        private final Provider<IdentifiedUser> identifiedUser;

        @Inject
        User(InternalFactory factory, GitRepositoryManager mgr, @GerritPersonIdent PersonIdent serverIdent, Provider<IdentifiedUser> identifiedUser) {
            this.factory = factory;
            this.mgr = mgr;
            this.serverIdent = serverIdent;
            this.identifiedUser = identifiedUser;
        }

        public PersonIdent getUserPersonIdent() {
            return this.createPersonIdent(this.identifiedUser.get());
        }

        public MetaDataUpdate create(Project.NameKey name) throws RepositoryNotFoundException, IOException {
            return this.create(name, this.identifiedUser.get());
        }

        public MetaDataUpdate create(Project.NameKey name, IdentifiedUser user) throws RepositoryNotFoundException, IOException {
            return this.create(name, user, null);
        }

        public MetaDataUpdate create(Project.NameKey name, IdentifiedUser user, BatchRefUpdate batch) throws RepositoryNotFoundException, IOException {
            Repository repo = this.mgr.openRepository(name);
            MetaDataUpdate md = this.create(name, repo, user, batch);
            md.setCloseRepository(true);
            return md;
        }

        public MetaDataUpdate create(Project.NameKey name, Repository repository, IdentifiedUser user, BatchRefUpdate batch) {
            MetaDataUpdate md = this.factory.create(name, repository, batch);
            md.getCommitBuilder().setCommitter(this.serverIdent);
            md.setAuthor(user);
            return md;
        }

        private PersonIdent createPersonIdent(IdentifiedUser user) {
            return user.newCommitterIdent(this.serverIdent.getWhen(), this.serverIdent.getTimeZone());
        }
    }
}

