/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.git;

import com.google.gerrit.common.Nullable;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.Branch;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.reviewdb.client.RefNames;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.git.SearchingChangeCacheImpl;
import com.google.gerrit.server.git.TagCache;
import com.google.gerrit.server.git.TagMatcher;
import com.google.gerrit.server.notedb.ChangeNotes;
import com.google.gerrit.server.permissions.ChangePermission;
import com.google.gerrit.server.permissions.GlobalPermission;
import com.google.gerrit.server.permissions.PermissionBackend;
import com.google.gerrit.server.permissions.PermissionBackendException;
import com.google.gerrit.server.permissions.ProjectPermission;
import com.google.gerrit.server.permissions.RefPermission;
import com.google.gerrit.server.permissions.RefVisibilityControl;
import com.google.gerrit.server.project.ProjectControl;
import com.google.gerrit.server.project.ProjectState;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.assistedinject.Assisted;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.SymbolicRef;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.AbstractAdvertiseRefsHook;
import org.eclipse.jgit.transport.ServiceMayNotContinueException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VisibleRefFilter
extends AbstractAdvertiseRefsHook {
    private static final Logger log = LoggerFactory.getLogger(VisibleRefFilter.class);
    private final TagCache tagCache;
    private final ChangeNotes.Factory changeNotesFactory;
    @Nullable
    private final SearchingChangeCacheImpl changeCache;
    private final Provider<ReviewDb> db;
    private final Provider<CurrentUser> user;
    private final PermissionBackend permissionBackend;
    private final PermissionBackend.ForProject perm;
    private final ProjectState projectState;
    private final Repository git;
    private final RefVisibilityControl refVisibilityControl;
    private ProjectControl projectCtl;
    private boolean showMetadata = true;
    private String userEditPrefix;
    private Map<Change.Id, Branch.NameKey> visibleChanges;

    @Inject
    VisibleRefFilter(TagCache tagCache, ChangeNotes.Factory changeNotesFactory, @Nullable SearchingChangeCacheImpl changeCache, Provider<ReviewDb> db, Provider<CurrentUser> user, PermissionBackend permissionBackend, RefVisibilityControl refVisibilityControl, @Assisted ProjectState projectState, @Assisted Repository git) {
        this.tagCache = tagCache;
        this.changeNotesFactory = changeNotesFactory;
        this.changeCache = changeCache;
        this.db = db;
        this.user = user;
        this.permissionBackend = permissionBackend;
        this.perm = ((PermissionBackend.WithUser)permissionBackend.user(user).database(db)).project(projectState.getProject().getNameKey());
        this.projectState = projectState;
        this.git = git;
        this.refVisibilityControl = refVisibilityControl;
    }

    public VisibleRefFilter setShowMetadata(boolean show) {
        this.showMetadata = show;
        return this;
    }

    public Map<String, Ref> filter(Map<String, Ref> refs, boolean filterTagsSeparately) {
        boolean hasAccessDatabase;
        if (this.projectState.isAllUsers()) {
            refs = this.addUsersSelfSymref(refs);
        }
        PermissionBackend.WithUser withUser = this.permissionBackend.user(this.user);
        PermissionBackend.ForProject forProject = withUser.project(this.projectState.getNameKey());
        if (!this.projectState.isAllUsers()) {
            if (this.checkProjectPermission(forProject, ProjectPermission.READ)) {
                return refs;
            }
            if (this.checkProjectPermission(forProject, ProjectPermission.READ_NO_CONFIG)) {
                return this.fastHideRefsMetaConfig(refs);
            }
        }
        if (this.user.get().isIdentifiedUser()) {
            hasAccessDatabase = withUser.testOrFalse(GlobalPermission.ACCESS_DATABASE);
            IdentifiedUser u = this.user.get().asIdentifiedUser();
            Account.Id userId = u.getAccountId();
            this.userEditPrefix = RefNames.refsEditPrefix(userId);
        } else {
            hasAccessDatabase = false;
        }
        HashMap<String, Ref> resultRefs = new HashMap<String, Ref>();
        ArrayList<Ref> deferredTags = new ArrayList<Ref>();
        this.projectCtl = this.projectState.controlFor(this.user.get());
        for (Ref ref : refs.values()) {
            String refName = ref.getName();
            if (!this.showMetadata && this.isMetadata(refName)) {
                log.debug("Filter out metadata ref %s", (Object)refName);
                continue;
            }
            if (VisibleRefFilter.isTag(ref)) {
                if (ref.getObjectId() != null) {
                    log.debug("Defer tag ref %s", (Object)refName);
                    deferredTags.add(ref);
                    continue;
                }
                log.debug("Filter out tag ref %s that is not a tag", (Object)refName);
                continue;
            }
            Change.Id changeId = Change.Id.fromRef(refName);
            if (changeId != null) {
                if (hasAccessDatabase) {
                    resultRefs.put(refName, ref);
                    continue;
                }
                if (!this.visible(changeId)) {
                    log.debug("Filter out invisible change ref %s", (Object)refName);
                    continue;
                }
                if (RefNames.isRefsEdit(refName) && !this.visibleEdit(refName)) {
                    log.debug("Filter out invisible change edit ref %s", (Object)refName);
                    continue;
                }
                resultRefs.put(refName, ref);
                continue;
            }
            try {
                if (!this.refVisibilityControl.isVisible(this.projectCtl, ref.getLeaf().getName())) continue;
                resultRefs.put(refName, ref);
            }
            catch (PermissionBackendException e) {
                log.warn("could not evaluate ref permission", e);
            }
        }
        if (!(deferredTags.isEmpty() || resultRefs.isEmpty() && !filterTagsSeparately)) {
            TagMatcher tags = this.tagCache.get(this.projectState.getNameKey()).matcher(this.tagCache, this.git, filterTagsSeparately ? this.filter(this.git.getAllRefs()).values() : resultRefs.values());
            for (Ref tag : deferredTags) {
                if (!tags.isReachable(tag)) continue;
                resultRefs.put(tag.getName(), tag);
            }
        }
        return resultRefs;
    }

    private Map<String, Ref> fastHideRefsMetaConfig(Map<String, Ref> refs) {
        if (refs.containsKey("refs/meta/config") && !this.canReadRef("refs/meta/config")) {
            HashMap<String, Ref> r = new HashMap<String, Ref>(refs);
            r.remove("refs/meta/config");
            return r;
        }
        return refs;
    }

    private Map<String, Ref> addUsersSelfSymref(Map<String, Ref> refs) {
        Ref r;
        if (this.user.get().isIdentifiedUser() && (r = refs.get(RefNames.refsUsers(this.user.get().getAccountId()))) != null) {
            SymbolicRef s = new SymbolicRef("refs/users/self", r);
            refs = new HashMap<String, Ref>(refs);
            refs.put(s.getName(), s);
        }
        return refs;
    }

    @Override
    protected Map<String, Ref> getAdvertisedRefs(Repository repository, RevWalk revWalk) throws ServiceMayNotContinueException {
        try {
            return this.filter(repository.getRefDatabase().getRefs(""));
        }
        catch (ServiceMayNotContinueException e) {
            throw e;
        }
        catch (IOException e) {
            ServiceMayNotContinueException ex = new ServiceMayNotContinueException();
            ex.initCause(e);
            throw ex;
        }
    }

    private Map<String, Ref> filter(Map<String, Ref> refs) {
        return this.filter(refs, false);
    }

    private boolean visible(Change.Id changeId) {
        if (this.visibleChanges == null) {
            this.visibleChanges = this.changeCache == null ? this.visibleChangesByScan() : this.visibleChangesBySearch();
        }
        return this.visibleChanges.containsKey(changeId);
    }

    private boolean visibleEdit(String name) {
        Change.Id id = Change.Id.fromEditRefPart(name);
        if (this.visibleChanges == null) {
            this.visible(id);
        }
        if (id != null) {
            return this.userEditPrefix != null && name.startsWith(this.userEditPrefix) && this.visible(id) || this.visibleChanges.containsKey(id) && this.projectCtl.controlForRef(this.visibleChanges.get(id)).isEditVisible();
        }
        return false;
    }

    private Map<Change.Id, Branch.NameKey> visibleChangesBySearch() {
        Project.NameKey project = this.projectState.getNameKey();
        try {
            HashMap<Change.Id, Branch.NameKey> visibleChanges = new HashMap<Change.Id, Branch.NameKey>();
            for (ChangeData cd : this.changeCache.getChangeData(this.db.get(), project)) {
                ChangeNotes notes;
                if (!this.perm.indexedChange(cd, notes = this.changeNotesFactory.createFromIndexedChange(cd.change())).test(ChangePermission.READ)) continue;
                visibleChanges.put(cd.getId(), cd.change().getDest());
            }
            return visibleChanges;
        }
        catch (PermissionBackendException | OrmException e) {
            log.error("Cannot load changes for project " + project + ", assuming no changes are visible", e);
            return Collections.emptyMap();
        }
    }

    private Map<Change.Id, Branch.NameKey> visibleChangesByScan() {
        Stream<ChangeNotes.Factory.ChangeNotesResult> s;
        Project.NameKey p = this.projectState.getNameKey();
        try {
            s = this.changeNotesFactory.scan(this.git, this.db.get(), p);
        }
        catch (IOException e) {
            log.error("Cannot load changes for project " + p + ", assuming no changes are visible", e);
            return Collections.emptyMap();
        }
        return s.map(r -> this.toNotes(p, (ChangeNotes.Factory.ChangeNotesResult)r)).filter(Objects::nonNull).collect(Collectors.toMap(n -> n.getChangeId(), n -> n.getChange().getDest()));
    }

    @Nullable
    private ChangeNotes toNotes(Project.NameKey p, ChangeNotes.Factory.ChangeNotesResult r) {
        if (r.error().isPresent()) {
            log.warn("Failed to load change " + r.id() + " in " + p, r.error().get());
            return null;
        }
        try {
            if (this.perm.change(r.notes()).test(ChangePermission.READ)) {
                return r.notes();
            }
        }
        catch (PermissionBackendException e) {
            log.warn("Failed to check permission for " + r.id() + " in " + p, e);
        }
        return null;
    }

    private boolean isMetadata(String name) {
        return name.startsWith("refs/changes/") || RefNames.isRefsEdit(name);
    }

    private static boolean isTag(Ref ref) {
        return ref.getLeaf().getName().startsWith("refs/tags/");
    }

    private static boolean isRefsUsersSelf(Ref ref) {
        return ref.getName().startsWith("refs/users/self");
    }

    private boolean canReadRef(String ref) {
        try {
            this.perm.ref(ref).check(RefPermission.READ);
            return true;
        }
        catch (AuthException e) {
            return false;
        }
        catch (PermissionBackendException e) {
            log.error("unable to check permissions", e);
            return false;
        }
    }

    private boolean checkProjectPermission(PermissionBackend.ForProject forProject, ProjectPermission perm) {
        try {
            forProject.check(perm);
        }
        catch (AuthException e) {
            return false;
        }
        catch (PermissionBackendException e) {
            log.error("Can't check permission for user {} on project {}", this.user.get(), this.projectState.getName(), e);
            return false;
        }
        return true;
    }

    public static interface Factory {
        public VisibleRefFilter create(ProjectState var1, Repository var2);
    }
}

