/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.git.strategy;

import com.google.common.base.Preconditions;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Sets;
import com.google.gerrit.extensions.api.changes.RecipientType;
import com.google.gerrit.extensions.api.changes.SubmitInput;
import com.google.gerrit.extensions.client.SubmitType;
import com.google.gerrit.extensions.config.FactoryModule;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.Branch;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.ApprovalsUtil;
import com.google.gerrit.server.ChangeMessagesUtil;
import com.google.gerrit.server.GerritPersonIdent;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.PatchSetUtil;
import com.google.gerrit.server.account.AccountCache;
import com.google.gerrit.server.change.RebaseChangeOp;
import com.google.gerrit.server.change.Submit;
import com.google.gerrit.server.extensions.events.ChangeMerged;
import com.google.gerrit.server.git.CodeReviewCommit;
import com.google.gerrit.server.git.EmailMerge;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.git.IntegrationException;
import com.google.gerrit.server.git.LabelNormalizer;
import com.google.gerrit.server.git.MergeOp;
import com.google.gerrit.server.git.MergeSorter;
import com.google.gerrit.server.git.MergeTip;
import com.google.gerrit.server.git.MergeUtil;
import com.google.gerrit.server.git.RebaseSorter;
import com.google.gerrit.server.git.SubmoduleOp;
import com.google.gerrit.server.git.TagCache;
import com.google.gerrit.server.git.strategy.ImplicitIntegrateOp;
import com.google.gerrit.server.git.strategy.SubmitStrategyOp;
import com.google.gerrit.server.git.strategy.TestHelperOp;
import com.google.gerrit.server.git.validators.OnSubmitValidators;
import com.google.gerrit.server.patch.PatchSetInfoFactory;
import com.google.gerrit.server.project.ProjectCache;
import com.google.gerrit.server.project.ProjectState;
import com.google.gerrit.server.query.change.InternalChangeQuery;
import com.google.gerrit.server.update.BatchUpdate;
import com.google.gerrit.server.util.RequestId;
import com.google.inject.Inject;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.assistedinject.Assisted;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevFlag;

public abstract class SubmitStrategy {
    final Arguments args;

    public static Module module() {
        return new FactoryModule(){

            @Override
            protected void configure() {
                this.factory(Arguments.Factory.class);
            }
        };
    }

    SubmitStrategy(Arguments args) {
        this.args = Preconditions.checkNotNull(args);
    }

    public final void addOps(BatchUpdate bu, Set<CodeReviewCommit> toMerge) throws IntegrationException {
        List<SubmitStrategyOp> ops = this.buildOps(toMerge);
        HashSet<CodeReviewCommit> added = Sets.newHashSetWithExpectedSize(ops.size());
        for (SubmitStrategyOp op : ops) {
            added.add(op.getCommit());
        }
        ArrayList<CodeReviewCommit> difference = new ArrayList<CodeReviewCommit>(Sets.difference(toMerge, added));
        Collections.reverse(difference);
        for (CodeReviewCommit c : difference) {
            Change.Id id = c.change().getId();
            bu.addOp(id, new ImplicitIntegrateOp(this.args, c));
            this.maybeAddTestHelperOp(bu, id);
        }
        for (SubmitStrategyOp op : ops) {
            bu.addOp(op.getId(), op);
            this.maybeAddTestHelperOp(bu, op.getId());
        }
    }

    private void maybeAddTestHelperOp(BatchUpdate bu, Change.Id changeId) {
        if (this.args.submitInput instanceof Submit.TestSubmitInput) {
            bu.addOp(changeId, new TestHelperOp(changeId, this.args));
        }
    }

    protected abstract List<SubmitStrategyOp> buildOps(Collection<CodeReviewCommit> var1) throws IntegrationException;

    static class Arguments {
        final AccountCache accountCache;
        final ApprovalsUtil approvalsUtil;
        final ChangeMerged changeMerged;
        final ChangeMessagesUtil cmUtil;
        final EmailMerge.Factory mergedSenderFactory;
        final GitRepositoryManager repoManager;
        final LabelNormalizer labelNormalizer;
        final PatchSetInfoFactory patchSetInfoFactory;
        final PatchSetUtil psUtil;
        final ProjectCache projectCache;
        final PersonIdent serverIdent;
        final RebaseChangeOp.Factory rebaseFactory;
        final OnSubmitValidators.Factory onSubmitValidatorsFactory;
        final TagCache tagCache;
        final Provider<InternalChangeQuery> queryProvider;
        final Branch.NameKey destBranch;
        final CodeReviewCommit.CodeReviewRevWalk rw;
        final MergeOp.CommitStatus commitStatus;
        final IdentifiedUser caller;
        final MergeTip mergeTip;
        final RevFlag canMergeFlag;
        final ReviewDb db;
        final Set<RevCommit> alreadyAccepted;
        final RequestId submissionId;
        final SubmitType submitType;
        final SubmitInput submitInput;
        final ListMultimap<RecipientType, Account.Id> accountsToNotify;
        final SubmoduleOp submoduleOp;
        final ProjectState project;
        final MergeSorter mergeSorter;
        final RebaseSorter rebaseSorter;
        final MergeUtil mergeUtil;
        final boolean dryrun;

        @Inject
        Arguments(AccountCache accountCache, ApprovalsUtil approvalsUtil, ChangeMerged changeMerged, ChangeMessagesUtil cmUtil, EmailMerge.Factory mergedSenderFactory, GitRepositoryManager repoManager, LabelNormalizer labelNormalizer, MergeUtil.Factory mergeUtilFactory, PatchSetInfoFactory patchSetInfoFactory, PatchSetUtil psUtil, @GerritPersonIdent PersonIdent serverIdent, ProjectCache projectCache, RebaseChangeOp.Factory rebaseFactory, OnSubmitValidators.Factory onSubmitValidatorsFactory, TagCache tagCache, Provider<InternalChangeQuery> queryProvider, @Assisted Branch.NameKey destBranch, @Assisted MergeOp.CommitStatus commitStatus, @Assisted CodeReviewCommit.CodeReviewRevWalk rw, @Assisted IdentifiedUser caller, @Assisted MergeTip mergeTip, @Assisted RevFlag canMergeFlag, @Assisted ReviewDb db, @Assisted Set<RevCommit> alreadyAccepted, @Assisted Set<CodeReviewCommit> incoming, @Assisted RequestId submissionId, @Assisted SubmitType submitType, @Assisted SubmitInput submitInput, @Assisted ListMultimap<RecipientType, Account.Id> accountsToNotify, @Assisted SubmoduleOp submoduleOp, @Assisted boolean dryrun) {
            this.accountCache = accountCache;
            this.approvalsUtil = approvalsUtil;
            this.changeMerged = changeMerged;
            this.mergedSenderFactory = mergedSenderFactory;
            this.repoManager = repoManager;
            this.cmUtil = cmUtil;
            this.labelNormalizer = labelNormalizer;
            this.patchSetInfoFactory = patchSetInfoFactory;
            this.psUtil = psUtil;
            this.projectCache = projectCache;
            this.rebaseFactory = rebaseFactory;
            this.tagCache = tagCache;
            this.queryProvider = queryProvider;
            this.serverIdent = serverIdent;
            this.destBranch = destBranch;
            this.commitStatus = commitStatus;
            this.rw = rw;
            this.caller = caller;
            this.mergeTip = mergeTip;
            this.canMergeFlag = canMergeFlag;
            this.db = db;
            this.alreadyAccepted = alreadyAccepted;
            this.submissionId = submissionId;
            this.submitType = submitType;
            this.submitInput = submitInput;
            this.accountsToNotify = accountsToNotify;
            this.submoduleOp = submoduleOp;
            this.dryrun = dryrun;
            this.project = Preconditions.checkNotNull(projectCache.get(destBranch.getParentKey()), "project not found: %s", (Object)destBranch.getParentKey());
            this.mergeSorter = new MergeSorter(rw, alreadyAccepted, canMergeFlag, incoming);
            this.rebaseSorter = new RebaseSorter(rw, mergeTip.getInitialTip(), alreadyAccepted, canMergeFlag, queryProvider, incoming);
            this.mergeUtil = mergeUtilFactory.create(this.project);
            this.onSubmitValidatorsFactory = onSubmitValidatorsFactory;
        }

        static interface Factory {
            public Arguments create(SubmitType var1, Branch.NameKey var2, MergeOp.CommitStatus var3, CodeReviewCommit.CodeReviewRevWalk var4, IdentifiedUser var5, MergeTip var6, RevFlag var7, ReviewDb var8, Set<RevCommit> var9, Set<CodeReviewCommit> var10, RequestId var11, SubmitInput var12, ListMultimap<RecipientType, Account.Id> var13, SubmoduleOp var14, boolean var15);
        }
    }
}

