/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.index;

import com.google.common.collect.ImmutableSet;
import com.google.gerrit.extensions.events.LifecycleListener;
import com.google.gerrit.index.Index;
import com.google.gerrit.index.IndexDefinition;
import com.google.gerrit.index.Schema;
import com.google.gerrit.lifecycle.LifecycleModule;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.inject.Inject;
import com.google.inject.ProvisionException;
import com.google.inject.Singleton;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import com.google.inject.util.Providers;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.eclipse.jgit.lib.Config;

@Singleton
public class SingleVersionModule
extends LifecycleModule {
    public static final String SINGLE_VERSIONS = "IndexModule/SingleVersions";
    private final Map<String, Integer> singleVersions;

    public SingleVersionModule(Map<String, Integer> singleVersions) {
        this.singleVersions = singleVersions;
    }

    @Override
    public void configure() {
        this.listener().to(SingleVersionListener.class);
        this.bind(new TypeLiteral<Map<String, Integer>>(){}).annotatedWith(Names.named(SINGLE_VERSIONS)).toProvider(Providers.of(this.singleVersions));
    }

    @Singleton
    public static class SingleVersionListener
    implements LifecycleListener {
        private final Set<String> disabled;
        private final Collection<IndexDefinition<?, ?, ?>> defs;
        private final Map<String, Integer> singleVersions;

        @Inject
        SingleVersionListener(@GerritServerConfig Config cfg, Collection<IndexDefinition<?, ?, ?>> defs, @Named(value="IndexModule/SingleVersions") Map<String, Integer> singleVersions) {
            this.defs = defs;
            this.singleVersions = singleVersions;
            this.disabled = ImmutableSet.copyOf(cfg.getStringList("index", null, "testDisable"));
        }

        @Override
        public void start() {
            for (IndexDefinition<?, ?, ?> def : this.defs) {
                this.start(def);
            }
        }

        private <K, V, I extends Index<K, V>> void start(IndexDefinition<K, V, I> def) {
            Schema<V> schema;
            if (this.disabled.contains(def.getName())) {
                return;
            }
            Integer v = this.singleVersions.get(def.getName());
            if (v == null) {
                schema = def.getLatest();
            } else {
                schema = def.getSchemas().get(v);
                if (schema == null) {
                    throw new ProvisionException(String.format("Unrecognized %s schema version: %s", def.getName(), v));
                }
            }
            I index = def.getIndexFactory().create(schema);
            def.getIndexCollection().setSearchIndex(index);
            def.getIndexCollection().addWriteIndex(index);
        }

        @Override
        public void stop() {
        }
    }
}

