/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.index.group;

import com.google.common.collect.ImmutableList;
import com.google.gerrit.index.FieldDef;
import com.google.gerrit.index.SchemaUtil;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.server.group.InternalGroup;
import java.sql.Timestamp;

public class GroupField {
    public static final FieldDef<InternalGroup, Integer> ID = FieldDef.integer("id").build(g -> g.getId().get());
    public static final FieldDef<InternalGroup, String> UUID = FieldDef.exact("uuid").stored().build(g -> g.getGroupUUID().get());
    public static final FieldDef<InternalGroup, String> OWNER_UUID = FieldDef.exact("owner_uuid").build(g -> g.getOwnerGroupUUID().get());
    public static final FieldDef<InternalGroup, Timestamp> CREATED_ON = FieldDef.timestamp("created_on").build(InternalGroup::getCreatedOn);
    public static final FieldDef<InternalGroup, String> NAME = FieldDef.exact("name").build(InternalGroup::getName);
    public static final FieldDef<InternalGroup, Iterable<String>> NAME_PART = FieldDef.prefix("name_part").buildRepeatable(g -> SchemaUtil.getNameParts(g.getName()));
    public static final FieldDef<InternalGroup, String> DESCRIPTION = FieldDef.fullText("description").build(InternalGroup::getDescription);
    public static final FieldDef<InternalGroup, String> IS_VISIBLE_TO_ALL = FieldDef.exact("is_visible_to_all").build(g -> g.isVisibleToAll() ? "1" : "0");
    public static final FieldDef<InternalGroup, Iterable<Integer>> MEMBER = FieldDef.integer("member").buildRepeatable(g -> g.getMembers().stream().map(Account.Id::get).collect(ImmutableList.toImmutableList()));
    public static final FieldDef<InternalGroup, Iterable<String>> SUBGROUP = FieldDef.exact("subgroup").buildRepeatable(g -> g.getSubgroups().stream().map(AccountGroup.UUID::get).collect(ImmutableList.toImmutableList()));
}

