/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.notedb;

import com.google.auto.value.AutoValue;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.Cache;
import com.google.common.collect.Table;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.reviewdb.client.RefNames;
import com.google.gerrit.server.ReviewerByEmailSet;
import com.google.gerrit.server.ReviewerSet;
import com.google.gerrit.server.cache.CacheModule;
import com.google.gerrit.server.notedb.AbstractChangeNotes;
import com.google.gerrit.server.notedb.AutoValue_ChangeNotesCache_Key;
import com.google.gerrit.server.notedb.AutoValue_ChangeNotesCache_Value;
import com.google.gerrit.server.notedb.ChangeNotesCommit;
import com.google.gerrit.server.notedb.ChangeNotesParser;
import com.google.gerrit.server.notedb.ChangeNotesState;
import com.google.gerrit.server.notedb.ChangeRevisionNote;
import com.google.gerrit.server.notedb.RevisionNoteMap;
import com.google.inject.Inject;
import com.google.inject.Module;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.lib.ObjectId;

@Singleton
public class ChangeNotesCache {
    @VisibleForTesting
    static final String CACHE_NAME = "change_notes";
    private final Cache<Key, ChangeNotesState> cache;
    private final AbstractChangeNotes.Args args;

    public static Module module() {
        return new CacheModule(){

            @Override
            protected void configure() {
                this.bind(ChangeNotesCache.class);
                this.cache(ChangeNotesCache.CACHE_NAME, Key.class, ChangeNotesState.class).weigher(Weigher.class).maximumWeight(0xA00000L);
            }
        };
    }

    @Inject
    ChangeNotesCache(@Named(value="change_notes") Cache<Key, ChangeNotesState> cache, AbstractChangeNotes.Args args) {
        this.cache = cache;
        this.args = args;
    }

    Value get(Project.NameKey project, Change.Id changeId, ObjectId metaId, ChangeNotesCommit.ChangeNotesRevWalk rw) throws IOException {
        try {
            AutoValue_ChangeNotesCache_Key key = new AutoValue_ChangeNotesCache_Key(project, changeId, metaId.copy());
            Loader loader = new Loader(key, rw);
            ChangeNotesState s = this.cache.get(key, loader);
            return new AutoValue_ChangeNotesCache_Value(s, loader.revisionNoteMap);
        }
        catch (ExecutionException e) {
            throw new IOException(String.format("Error loading %s in %s at %s", RefNames.changeMetaRef(changeId), project, metaId.name()), e);
        }
    }

    private class Loader
    implements Callable<ChangeNotesState> {
        private final Key key;
        private final ChangeNotesCommit.ChangeNotesRevWalk rw;
        private RevisionNoteMap<ChangeRevisionNote> revisionNoteMap;

        private Loader(Key key, ChangeNotesCommit.ChangeNotesRevWalk rw) {
            this.key = key;
            this.rw = rw;
        }

        @Override
        public ChangeNotesState call() throws ConfigInvalidException, IOException {
            ChangeNotesParser parser = new ChangeNotesParser(this.key.changeId(), this.key.id(), this.rw, ((ChangeNotesCache)ChangeNotesCache.this).args.noteUtil, ((ChangeNotesCache)ChangeNotesCache.this).args.metrics);
            ChangeNotesState result = parser.parseAll();
            this.revisionNoteMap = parser.getRevisionNoteMap();
            return result;
        }
    }

    @AutoValue
    static abstract class Value {
        Value() {
        }

        abstract ChangeNotesState state();

        @Nullable
        abstract RevisionNoteMap<ChangeRevisionNote> revisionNoteMap();
    }

    public static class Weigher
    implements com.google.common.cache.Weigher<Key, ChangeNotesState> {
        private static final int O = 16;
        private static final int P = 8;
        private static final int K = 20;
        private static final int T = 24;

        @Override
        public int weigh(Key key, ChangeNotesState state) {
            return 64 + Weigher.str(40) + 24 + 24 + 8 + 20 + 8 + Weigher.str(state.columns().branch()) + 8 + Weigher.patchSetId() + 8 + Weigher.str(state.columns().subject()) + 8 + Weigher.str(state.columns().topic()) + 8 + Weigher.str(state.columns().originalSubject()) + 8 + Weigher.str(state.columns().submissionId()) + Weigher.ptr(state.columns().assignee(), 20) + 8 + 8 + Weigher.set(state.pastAssignees(), 20) + 8 + Weigher.set(state.hashtags(), Weigher.str(10)) + 8 + Weigher.list(state.patchSets(), Weigher.patchSet()) + 8 + Weigher.reviewerSet(state.reviewers(), 2) + 8 + Weigher.reviewerSet(state.reviewersByEmail(), 2) + 8 + Weigher.reviewerSet(state.pendingReviewers(), 3) + 8 + Weigher.reviewerSet(state.pendingReviewersByEmail(), 3) + 8 + Weigher.list(state.allPastReviewers(), Weigher.approval()) + 8 + Weigher.list(state.reviewerUpdates(), 112) + 8 + Weigher.list(state.submitRecords(), 8 + Weigher.list(2, Weigher.str(4) + 8 + 20) + 8) + 8 + Weigher.list(state.allChangeMessages(), Weigher.changeMessage()) + 8 + Weigher.map(state.changeMessagesByPatchSet().asMap(), Weigher.patchSetId()) + 8 + Weigher.map(state.publishedComments().asMap(), Weigher.comment()) + 24 + 1 + 1 + 1;
        }

        private static int ptr(Object o, int size) {
            return o != null ? 8 + size : 8;
        }

        private static int str(String s) {
            if (s == null) {
                return 8;
            }
            return Weigher.str(s.length());
        }

        private static int str(int n) {
            return 32 + 2 * n;
        }

        private static int patchSetId() {
            return 40;
        }

        private static int set(Set<?> set, int elemSize) {
            if (set == null) {
                return 8;
            }
            return Weigher.hashtable(set.size(), elemSize);
        }

        private static int map(Map<?, ?> map, int elemSize) {
            if (map == null) {
                return 8;
            }
            return Weigher.hashtable(map.size(), elemSize);
        }

        private static int hashtable(int n, int elemSize) {
            int overhead = 32;
            int elemOverhead = 48;
            return overhead + elemOverhead * n * elemSize;
        }

        private static int list(List<?> list, int elemSize) {
            if (list == null) {
                return 8;
            }
            return Weigher.list(list.size(), elemSize);
        }

        private static int list(int n, int elemSize) {
            return 32 + n * (8 + elemSize);
        }

        private static int hashBasedTable(Table<?, ?, ?> table, int numRows, int rowKey, int columnKey, int elemSize) {
            return 16 + Weigher.hashtable(numRows, rowKey + Weigher.hashtable(0, 0)) + Weigher.hashtable(table.size(), columnKey + elemSize);
        }

        private static int reviewerSet(ReviewerSet reviewers, int numRows) {
            boolean rowKey = true;
            int columnKey = 20;
            int cellValue = 24;
            return Weigher.hashBasedTable(reviewers.asTable(), numRows, 1, 20, 24);
        }

        private static int reviewerSet(ReviewerByEmailSet reviewers, int numRows) {
            boolean rowKey = true;
            int columnKey = 8 + 2 * Weigher.str(20);
            int cellValue = 24;
            return Weigher.hashBasedTable(reviewers.asTable(), numRows, 1, columnKey, 24);
        }

        private static int patchSet() {
            return 24 + Weigher.patchSetId() + Weigher.str(40) + 8 + 20 + 8 + 24 + 1 + Weigher.str(40) + 8;
        }

        private static int approval() {
            return 24 + Weigher.patchSetId() + 8 + 20 + 8 + 16 + Weigher.str(10) + 2 + 8 + 24 + 8 + 8;
        }

        private static int changeMessage() {
            int key = 20 + Weigher.str(20);
            return 24 + key + 8 + 20 + 8 + 24 + Weigher.str(64) + 8 + Weigher.patchSetId() + 8 + 8;
        }

        private static int comment() {
            int key = 8 + Weigher.str(20) + 8 + Weigher.str(32) + 4;
            int ident = 20;
            return 24 + key + 4 + 8 + ident + 8 + ident + 8 + 24 + 2 + Weigher.str(32) + Weigher.str(10) + 20 + 8 + 8 + Weigher.str(40) + 8 + Weigher.str(36);
        }
    }

    @AutoValue
    public static abstract class Key {
        abstract Project.NameKey project();

        abstract Change.Id changeId();

        abstract ObjectId id();
    }
}

