/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.notedb.rebuild;

import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.server.notedb.ChangeUpdate;
import com.google.gerrit.server.notedb.rebuild.ChangeRebuilderImpl;
import com.google.gerrit.server.notedb.rebuild.Event;
import com.google.gwtorm.server.OrmException;
import java.io.IOException;

class CreateChangeEvent
extends Event {
    private final Change change;

    private static PatchSet.Id psId(Change change, Integer minPsNum) {
        int n = minPsNum == null ? 1 : minPsNum;
        return new PatchSet.Id(change.getId(), n);
    }

    CreateChangeEvent(Change change, Integer minPsNum) {
        super(CreateChangeEvent.psId(change, minPsNum), change.getOwner(), change.getOwner(), change.getCreatedOn(), change.getCreatedOn(), null);
        this.change = change;
    }

    @Override
    boolean uniquePerUpdate() {
        return true;
    }

    @Override
    void apply(ChangeUpdate update) throws IOException, OrmException {
        this.checkUpdate(update);
        ChangeRebuilderImpl.createChange(update, this.change);
    }
}

