/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.notedb.rebuild;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.server.notedb.rebuild.ChangeRebuilderImpl;
import com.google.gerrit.server.notedb.rebuild.Event;
import com.google.gerrit.server.notedb.rebuild.FinalUpdatesEvent;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Objects;

class EventList<E extends Event>
implements Iterable<E> {
    private final ArrayList<E> list = new ArrayList();
    private boolean isSubmit;

    EventList() {
    }

    @Override
    public Iterator<E> iterator() {
        return this.list.iterator();
    }

    void add(E e) {
        this.list.add(e);
        if (((Event)e).isSubmit()) {
            this.isSubmit = true;
        }
    }

    void clear() {
        this.list.clear();
        this.isSubmit = false;
    }

    boolean isEmpty() {
        return this.list.isEmpty();
    }

    boolean canAdd(E e) {
        if (this.isEmpty()) {
            return true;
        }
        if (e instanceof FinalUpdatesEvent) {
            return false;
        }
        E last = this.getLast();
        if (!(Objects.equals(((Event)e).user, ((Event)last).user) && Objects.equals(((Event)e).realUser, ((Event)last).realUser) && ((Event)e).psId.equals(((Event)last).psId))) {
            return false;
        }
        if (((Event)e).canHaveTag() && this.canHaveTag() && !Objects.equals(((Event)e).tag, this.getTag())) {
            return false;
        }
        if (((Event)e).isPostSubmitApproval() && this.isSubmit) {
            return false;
        }
        long t = ((Event)e).when.getTime();
        long tFirst = this.getFirstTime();
        long tLast = this.getLastTime();
        Preconditions.checkArgument(t >= tLast, "event %s is before previous event in list %s", e, last);
        if (t - tLast > ChangeRebuilderImpl.MAX_DELTA_MS || t - tFirst > ChangeRebuilderImpl.MAX_WINDOW_MS) {
            return false;
        }
        if (!((Event)e).uniquePerUpdate()) {
            return true;
        }
        for (Event o : this) {
            if (e.getClass() != o.getClass()) continue;
            return false;
        }
        return true;
    }

    Timestamp getWhen() {
        return ((Event)this.get((int)0)).when;
    }

    PatchSet.Id getPatchSetId() {
        PatchSet.Id id = Preconditions.checkNotNull(((Event)this.get((int)0)).psId);
        for (int i = 1; i < this.size(); ++i) {
            Preconditions.checkState(((Event)this.get((int)i)).psId.equals(id), "mismatched patch sets in EventList: %s != %s", (Object)id, (Object)((Event)this.get((int)i)).psId);
        }
        return id;
    }

    Account.Id getAccountId() {
        Account.Id id = ((Event)this.get((int)0)).user;
        for (int i = 1; i < this.size(); ++i) {
            Preconditions.checkState(Objects.equals(id, ((Event)this.get((int)i)).user), "mismatched users in EventList: %s != %s", (Object)id, (Object)((Event)this.get((int)i)).user);
        }
        return id;
    }

    Account.Id getRealAccountId() {
        Account.Id id = ((Event)this.get((int)0)).realUser;
        for (int i = 1; i < this.size(); ++i) {
            Preconditions.checkState(Objects.equals(id, ((Event)this.get((int)i)).realUser), "mismatched real users in EventList: %s != %s", (Object)id, (Object)((Event)this.get((int)i)).realUser);
        }
        return id;
    }

    String getTag() {
        for (Event e : Lists.reverse(this.list)) {
            if (e.tag == null) continue;
            return e.tag;
        }
        return null;
    }

    private boolean canHaveTag() {
        return this.list.stream().anyMatch(Event::canHaveTag);
    }

    private E get(int i) {
        return (E)((Event)this.list.get(i));
    }

    private int size() {
        return this.list.size();
    }

    private E getLast() {
        return (E)((Event)this.list.get(this.list.size() - 1));
    }

    private long getLastTime() {
        return ((Event)this.getLast()).when.getTime();
    }

    private long getFirstTime() {
        return ((Event)this.list.get((int)0)).when.getTime();
    }
}

