/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.permissions;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.google.gerrit.common.data.LabelType;
import com.google.gerrit.common.data.LabelValue;
import com.google.gerrit.extensions.api.access.GlobalOrPluginPermission;
import com.google.gerrit.extensions.conditions.BooleanCondition;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.reviewdb.client.Branch;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.notedb.ChangeNotes;
import com.google.gerrit.server.permissions.ChangePermissionOrLabel;
import com.google.gerrit.server.permissions.FailedPermissionBackend;
import com.google.gerrit.server.permissions.LabelPermission;
import com.google.gerrit.server.permissions.PermissionBackendCondition;
import com.google.gerrit.server.permissions.PermissionBackendException;
import com.google.gerrit.server.permissions.ProjectPermission;
import com.google.gerrit.server.permissions.RefPermission;
import com.google.gerrit.server.project.DefaultPermissionBackend;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gwtorm.server.OrmException;
import com.google.inject.ImplementedBy;
import com.google.inject.Provider;
import com.google.inject.util.Providers;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ImplementedBy(value=DefaultPermissionBackend.class)
public abstract class PermissionBackend {
    private static final Logger logger = LoggerFactory.getLogger(PermissionBackend.class);

    public abstract WithUser user(CurrentUser var1);

    public <U extends CurrentUser> WithUser user(Provider<U> user) {
        return this.user((CurrentUser)Preconditions.checkNotNull(user, "Provider<CurrentUser>").get());
    }

    public void bulkEvaluateTest(Collection<PermissionBackendCondition> conds) {
    }

    public static abstract class ForChange
    extends AcceptsReviewDb<ForChange> {
        public abstract CurrentUser user();

        public abstract ForChange user(CurrentUser var1);

        public abstract void check(ChangePermissionOrLabel var1) throws AuthException, PermissionBackendException;

        public abstract <T extends ChangePermissionOrLabel> Set<T> test(Collection<T> var1) throws PermissionBackendException;

        public boolean test(ChangePermissionOrLabel perm) throws PermissionBackendException {
            return this.test(Collections.singleton(perm)).contains(perm);
        }

        public boolean testOrFalse(ChangePermissionOrLabel perm) {
            try {
                return this.test(perm);
            }
            catch (PermissionBackendException e) {
                logger.warn("Cannot test " + perm + "; assuming false", e);
                return false;
            }
        }

        public BooleanCondition testCond(ChangePermissionOrLabel perm) {
            return new PermissionBackendCondition.ForChange(this, perm);
        }

        public Set<LabelPermission.WithValue> test(LabelType label) throws PermissionBackendException {
            return this.test(ForChange.valuesOf(Preconditions.checkNotNull(label, "LabelType")));
        }

        public Set<LabelPermission.WithValue> testLabels(Collection<LabelType> types) throws PermissionBackendException {
            Preconditions.checkNotNull(types, "LabelType");
            return this.test(types.stream().flatMap(t -> ForChange.valuesOf(t).stream()).collect(Collectors.toSet()));
        }

        private static Set<LabelPermission.WithValue> valuesOf(LabelType label) {
            return label.getValues().stream().map(v -> new LabelPermission.WithValue(label, (LabelValue)v)).collect(Collectors.toSet());
        }
    }

    public static abstract class ForRef
    extends AcceptsReviewDb<ForRef> {
        public abstract ForRef user(CurrentUser var1);

        public abstract ForChange change(ChangeData var1);

        public abstract ForChange change(ChangeNotes var1);

        public abstract ForChange indexedChange(ChangeData var1, ChangeNotes var2);

        public abstract void check(RefPermission var1) throws AuthException, PermissionBackendException;

        public abstract Set<RefPermission> test(Collection<RefPermission> var1) throws PermissionBackendException;

        public boolean test(RefPermission perm) throws PermissionBackendException {
            return this.test(EnumSet.of(perm)).contains((Object)perm);
        }

        public boolean testOrFalse(RefPermission perm) {
            try {
                return this.test(perm);
            }
            catch (PermissionBackendException e) {
                logger.warn("Cannot test " + (Object)((Object)perm) + "; assuming false", e);
                return false;
            }
        }

        public BooleanCondition testCond(RefPermission perm) {
            return new PermissionBackendCondition.ForRef(this, perm);
        }
    }

    public static abstract class ForProject
    extends AcceptsReviewDb<ForProject> {
        public abstract ForProject user(CurrentUser var1);

        public abstract ForRef ref(String var1);

        public ForChange change(ChangeData cd) {
            try {
                return this.ref(cd.change().getDest().get()).change(cd);
            }
            catch (OrmException e) {
                return FailedPermissionBackend.change("unavailable", e);
            }
        }

        public ForChange change(ChangeNotes notes) {
            return this.ref(notes.getChange().getDest().get()).change(notes);
        }

        public ForChange indexedChange(ChangeData cd, ChangeNotes notes) {
            return this.ref(notes.getChange().getDest().get()).indexedChange(cd, notes);
        }

        public abstract void check(ProjectPermission var1) throws AuthException, PermissionBackendException;

        public abstract Set<ProjectPermission> test(Collection<ProjectPermission> var1) throws PermissionBackendException;

        public boolean test(ProjectPermission perm) throws PermissionBackendException {
            return this.test(EnumSet.of(perm)).contains((Object)perm);
        }

        public boolean testOrFalse(ProjectPermission perm) {
            try {
                return this.test(perm);
            }
            catch (PermissionBackendException e) {
                logger.warn("Cannot test " + (Object)((Object)perm) + "; assuming false", e);
                return false;
            }
        }

        public BooleanCondition testCond(ProjectPermission perm) {
            return new PermissionBackendCondition.ForProject(this, perm);
        }
    }

    public static abstract class WithUser
    extends AcceptsReviewDb<WithUser> {
        public abstract ForProject project(Project.NameKey var1);

        public ForRef ref(Branch.NameKey ref) {
            return (ForRef)this.project(ref.getParentKey()).ref(ref.get()).database(this.db);
        }

        public ForChange change(ChangeData cd) {
            try {
                return this.ref(cd.change().getDest()).change(cd);
            }
            catch (OrmException e) {
                return FailedPermissionBackend.change("unavailable", e);
            }
        }

        public ForChange change(ChangeNotes notes) {
            return this.ref(notes.getChange().getDest()).change(notes);
        }

        public ForChange indexedChange(ChangeData cd, ChangeNotes notes) {
            return this.ref(notes.getChange().getDest()).indexedChange(cd, notes);
        }

        public abstract void check(GlobalOrPluginPermission var1) throws AuthException, PermissionBackendException;

        public void checkAny(Set<GlobalOrPluginPermission> any) throws PermissionBackendException, AuthException {
            Iterator<GlobalOrPluginPermission> itr = any.iterator();
            while (itr.hasNext()) {
                try {
                    this.check(itr.next());
                    return;
                }
                catch (AuthException err) {
                    if (itr.hasNext()) continue;
                    throw err;
                }
            }
        }

        public abstract <T extends GlobalOrPluginPermission> Set<T> test(Collection<T> var1) throws PermissionBackendException;

        public boolean test(GlobalOrPluginPermission perm) throws PermissionBackendException {
            return this.test(Collections.singleton(perm)).contains(perm);
        }

        public boolean testOrFalse(GlobalOrPluginPermission perm) {
            try {
                return this.test(perm);
            }
            catch (PermissionBackendException e) {
                logger.warn("Cannot test " + perm + "; assuming false", e);
                return false;
            }
        }

        public BooleanCondition testCond(GlobalOrPluginPermission perm) {
            return new PermissionBackendCondition.WithUser(this, perm);
        }

        public Set<Project.NameKey> filter(ProjectPermission perm, Collection<Project.NameKey> projects) throws PermissionBackendException {
            Preconditions.checkNotNull(perm, "ProjectPermission");
            Preconditions.checkNotNull(projects, "projects");
            HashSet<Project.NameKey> allowed = Sets.newHashSetWithExpectedSize(projects.size());
            for (Project.NameKey project : projects) {
                try {
                    this.project(project).check(perm);
                    allowed.add(project);
                }
                catch (AuthException authException) {
                }
                catch (PermissionBackendException e) {
                    if (e.getCause() instanceof RepositoryNotFoundException) {
                        logger.warn("Could not find repository of the project {} : ", (Object)project.get(), (Object)e);
                        continue;
                    }
                    throw e;
                }
            }
            return allowed;
        }
    }

    public static abstract class AcceptsReviewDb<T> {
        protected Provider<ReviewDb> db;

        public T database(Provider<ReviewDb> db) {
            if (db != null) {
                this.db = db;
            }
            return this.self();
        }

        public T database(ReviewDb db) {
            return this.database(Providers.of(Preconditions.checkNotNull(db, "ReviewDb")));
        }

        private T self() {
            return (T)this;
        }
    }
}

