/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.permissions;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.RefNames;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.notedb.ChangeNotes;
import com.google.gerrit.server.permissions.GlobalPermission;
import com.google.gerrit.server.permissions.PermissionBackend;
import com.google.gerrit.server.permissions.PermissionBackendException;
import com.google.gerrit.server.permissions.ProjectPermission;
import com.google.gerrit.server.project.ChangeControl;
import com.google.gerrit.server.project.NoSuchChangeException;
import com.google.gerrit.server.project.ProjectControl;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gerrit.server.util.ManualRequestContext;
import com.google.gerrit.server.util.OneOffRequestContext;
import com.google.gwtorm.server.OrmException;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class RefVisibilityControl {
    private static final Logger logger = LoggerFactory.getLogger(RefVisibilityControl.class);
    private final Provider<ReviewDb> dbProvider;
    private final OneOffRequestContext oneOffRequestContext;
    private final PermissionBackend permissionBackend;
    private final ChangeData.Factory changeDataFactory;

    @Inject
    RefVisibilityControl(Provider<ReviewDb> dbProvider, OneOffRequestContext oneOffRequestContext, PermissionBackend permissionBackend, ChangeData.Factory changeDataFactory) {
        this.dbProvider = dbProvider;
        this.oneOffRequestContext = oneOffRequestContext;
        this.permissionBackend = permissionBackend;
        this.changeDataFactory = changeDataFactory;
    }

    public boolean isVisible(ProjectControl projectControl, String refName) throws PermissionBackendException {
        if (refName.startsWith("refs/tags/")) {
            throw new PermissionBackendException("can't check tags through RefVisibilityControl. Use PermissionBackend#filter instead.");
        }
        if (!RefNames.isGerritRef(refName)) {
            return projectControl.controlForRef(refName).hasReadPermissionOnRef(false);
        }
        if (refName.startsWith("refs/cache-automerge/")) {
            return false;
        }
        boolean hasAccessDatabase = this.permissionBackend.user(projectControl.getUser()).testOrFalse(GlobalPermission.ACCESS_DATABASE);
        if (hasAccessDatabase) {
            return true;
        }
        Change.Id changeId = Change.Id.fromRef(refName);
        if (changeId != null) {
            CloseableOneTimeReviewDb ignored = new CloseableOneTimeReviewDb();
            try {
                ChangeData cd;
                try {
                    cd = this.changeDataFactory.create(this.dbProvider.get(), projectControl.getProject().getNameKey(), changeId);
                    Preconditions.checkState(cd.change().getId().equals(changeId));
                }
                catch (OrmException e) {
                    if (Throwables.getCausalChain(e).stream().anyMatch(e2 -> e2 instanceof NoSuchChangeException)) {
                        PermissionBackend.ForProject forProject = projectControl.asForProject();
                        boolean bl = forProject.test(ProjectPermission.READ);
                        ignored.close();
                        return bl;
                    }
                    throw new PermissionBackendException(e);
                }
                if (RefNames.isRefsEdit(refName)) {
                    boolean e = this.visibleEdit(refName, projectControl, cd);
                    return e;
                }
                boolean e = this.isVisible(projectControl.controlFor(this.getNotes(cd)).setChangeData(cd));
                return e;
            }
            finally {
                try {
                    ignored.close();
                }
                catch (Throwable e) {
                    Throwable cd;
                    cd.addSuppressed(e);
                }
            }
        }
        CurrentUser user = projectControl.getUser();
        Account.Id currentUserAccountId = user.isIdentifiedUser() ? user.getAccountId() : null;
        Account.Id accountId = Account.Id.fromRef(refName);
        if (accountId != null) {
            return accountId.equals(currentUserAccountId) && projectControl.controlForRef(refName).hasReadPermissionOnRef(true);
        }
        logger.debug("Denying access to %s because user doesn't have access to this Gerrit ref", (Object)refName);
        return false;
    }

    private boolean visibleEdit(String refName, ProjectControl projectControl, ChangeData cd) throws PermissionBackendException {
        Change.Id id = Change.Id.fromEditRefPart(refName);
        if (id == null) {
            throw new IllegalStateException("unable to parse change id from edit ref " + refName);
        }
        if (!this.isVisible(projectControl.controlFor(this.getNotes(cd)).setChangeData(cd))) {
            return false;
        }
        if (projectControl.getUser().isIdentifiedUser() && refName.startsWith(RefNames.refsEditPrefix(projectControl.getUser().asIdentifiedUser().getAccountId()))) {
            logger.debug("Own change edit ref is visible: %s", (Object)refName);
            return true;
        }
        return false;
    }

    private ChangeNotes getNotes(ChangeData cd) throws PermissionBackendException {
        try {
            return cd.notes();
        }
        catch (OrmException e) {
            throw new PermissionBackendException(e);
        }
    }

    private boolean isVisible(ChangeControl changeControl) throws PermissionBackendException {
        try {
            return changeControl.isVisible(this.dbProvider.get());
        }
        catch (OrmException e) {
            throw new PermissionBackendException(e);
        }
    }

    private Optional<ReviewDb> getReviewDb() {
        try {
            return Optional.of(this.dbProvider.get());
        }
        catch (Exception e) {
            return Optional.absent();
        }
    }

    private class CloseableOneTimeReviewDb
    implements AutoCloseable {
        @Nullable
        private final ManualRequestContext ctx;

        CloseableOneTimeReviewDb() throws PermissionBackendException {
            if (!RefVisibilityControl.this.getReviewDb().isPresent()) {
                try {
                    this.ctx = RefVisibilityControl.this.oneOffRequestContext.open();
                }
                catch (OrmException e) {
                    throw new PermissionBackendException(e);
                }
            } else {
                this.ctx = null;
            }
        }

        @Override
        public void close() {
            if (this.ctx != null) {
                this.ctx.close();
            }
        }
    }
}

