/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.project;

import com.google.gerrit.extensions.registration.DynamicMap;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.ChildCollection;
import com.google.gerrit.extensions.restapi.IdString;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.RestView;
import com.google.gerrit.extensions.restapi.TopLevelResource;
import com.google.gerrit.server.permissions.PermissionBackendException;
import com.google.gerrit.server.project.ChildProjectResource;
import com.google.gerrit.server.project.ListChildProjects;
import com.google.gerrit.server.project.ProjectResource;
import com.google.gerrit.server.project.ProjectState;
import com.google.gerrit.server.project.ProjectsCollection;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;

@Singleton
public class ChildProjectsCollection
implements ChildCollection<ProjectResource, ChildProjectResource> {
    private final Provider<ListChildProjects> list;
    private final ProjectsCollection projectsCollection;
    private final DynamicMap<RestView<ChildProjectResource>> views;

    @Inject
    ChildProjectsCollection(Provider<ListChildProjects> list, ProjectsCollection projectsCollection, DynamicMap<RestView<ChildProjectResource>> views) {
        this.list = list;
        this.projectsCollection = projectsCollection;
        this.views = views;
    }

    public ListChildProjects list() throws ResourceNotFoundException, AuthException {
        return this.list.get();
    }

    @Override
    public ChildProjectResource parse(ProjectResource parent, IdString id) throws ResourceNotFoundException, IOException, PermissionBackendException {
        ProjectResource p = this.projectsCollection.parse(TopLevelResource.INSTANCE, id);
        for (ProjectState pp : p.getControl().getProjectState().parents()) {
            if (!parent.getNameKey().equals(pp.getProject().getNameKey())) continue;
            return new ChildProjectResource(parent, p.getProjectState());
        }
        throw new ResourceNotFoundException(id);
    }

    @Override
    public DynamicMap<RestView<ChildProjectResource>> views() {
        return this.views;
    }
}

