/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.project;

import com.google.gerrit.common.Nullable;
import com.google.gerrit.common.data.ContributorAgreement;
import com.google.gerrit.common.data.PermissionRule;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.config.CanonicalWebUrl;
import com.google.gerrit.server.project.ProjectCache;
import com.google.gerrit.server.project.ProjectControl;
import com.google.gerrit.server.project.ProjectState;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;

@Singleton
public class ContributorAgreementsChecker {
    private final String canonicalWebUrl;
    private final ProjectCache projectCache;
    private final ProjectControl.Metrics metrics;

    @Inject
    ContributorAgreementsChecker(@CanonicalWebUrl @Nullable String canonicalWebUrl, ProjectCache projectCache, ProjectControl.Metrics metrics) {
        this.canonicalWebUrl = canonicalWebUrl;
        this.projectCache = projectCache;
        this.metrics = metrics;
    }

    public void check(Project.NameKey project, CurrentUser user) throws IOException, AuthException {
        this.metrics.claCheckCount.increment();
        ProjectState projectState = this.projectCache.checkedGet(project);
        if (projectState == null) {
            throw new IOException("Can't load All-Projects");
        }
        if (!projectState.isUseContributorAgreements()) {
            return;
        }
        if (!user.isIdentifiedUser()) {
            throw new AuthException("Must be logged in to verify Contributor Agreement");
        }
        IdentifiedUser iUser = user.asIdentifiedUser();
        Collection<ContributorAgreement> contributorAgreements = this.projectCache.getAllProjects().getConfig().getContributorAgreements();
        ArrayList<AccountGroup.UUID> okGroupIds = new ArrayList<AccountGroup.UUID>();
        for (ContributorAgreement ca : contributorAgreements) {
            ArrayList<AccountGroup.UUID> groupIds = okGroupIds;
            for (PermissionRule rule : ca.getAccepted()) {
                if (rule.getAction() != PermissionRule.Action.ALLOW || rule.getGroup() == null || rule.getGroup().getUUID() == null) continue;
                groupIds.add(new AccountGroup.UUID(rule.getGroup().getUUID().get()));
            }
        }
        if (!iUser.getEffectiveGroups().containsAnyOf(okGroupIds)) {
            StringBuilder msg = new StringBuilder();
            msg.append("A Contributor Agreement must be completed before uploading");
            if (this.canonicalWebUrl != null) {
                msg.append(":\n\n  ");
                msg.append(this.canonicalWebUrl);
                msg.append("#");
                msg.append("/settings/agreements");
                msg.append("\n");
            } else {
                msg.append(".");
            }
            throw new AuthException(msg.toString());
        }
    }
}

