/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.project;

import com.google.gerrit.extensions.restapi.IdString;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.RestResource;
import com.google.gerrit.extensions.restapi.RestView;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.project.ProjectState;
import com.google.inject.TypeLiteral;
import java.io.IOException;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.TreeWalk;

public class FileResource
implements RestResource {
    public static final TypeLiteral<RestView<FileResource>> FILE_KIND = new TypeLiteral<RestView<FileResource>>(){};
    private final ProjectState projectState;
    private final ObjectId rev;
    private final String path;

    public static FileResource create(GitRepositoryManager repoManager, ProjectState projectState, ObjectId rev, String path) throws ResourceNotFoundException, IOException {
        try (Repository repo = repoManager.openRepository(projectState.getNameKey());
             RevWalk rw = new RevWalk(repo);){
            RevTree tree = rw.parseTree(rev);
            if (TreeWalk.forPath(repo, path, tree) != null) {
                FileResource fileResource = new FileResource(projectState, rev, path);
                return fileResource;
            }
        }
        throw new ResourceNotFoundException(IdString.fromDecoded(path));
    }

    public FileResource(ProjectState projectState, ObjectId rev, String path) {
        this.projectState = projectState;
        this.rev = rev;
        this.path = path;
    }

    public ProjectState getProjectState() {
        return this.projectState;
    }

    public ObjectId getRev() {
        return this.rev;
    }

    public String getPath() {
        return this.path;
    }
}

