/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.project;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.gerrit.extensions.common.ProjectInfo;
import com.google.gerrit.extensions.restapi.RestReadView;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.config.AllProjectsName;
import com.google.gerrit.server.permissions.PermissionBackend;
import com.google.gerrit.server.permissions.PermissionBackendException;
import com.google.gerrit.server.permissions.ProjectPermission;
import com.google.gerrit.server.project.ProjectCache;
import com.google.gerrit.server.project.ProjectJson;
import com.google.gerrit.server.project.ProjectResource;
import com.google.gerrit.server.project.ProjectState;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.kohsuke.args4j.Option;

public class ListChildProjects
implements RestReadView<ProjectResource> {
    @Option(name="--recursive", usage="to list child projects recursively")
    private boolean recursive;
    private final ProjectCache projectCache;
    private final PermissionBackend permissionBackend;
    private final Provider<CurrentUser> user;
    private final AllProjectsName allProjects;
    private final ProjectJson json;

    @Inject
    ListChildProjects(ProjectCache projectCache, PermissionBackend permissionBackend, Provider<CurrentUser> user, AllProjectsName allProjectsName, ProjectJson json) {
        this.projectCache = projectCache;
        this.permissionBackend = permissionBackend;
        this.user = user;
        this.allProjects = allProjectsName;
        this.json = json;
    }

    public void setRecursive(boolean recursive) {
        this.recursive = recursive;
    }

    public List<ProjectInfo> apply(ProjectResource rsrc) throws PermissionBackendException {
        if (this.recursive) {
            return this.recursiveChildProjects(rsrc.getNameKey());
        }
        return this.directChildProjects(rsrc.getNameKey());
    }

    private List<ProjectInfo> directChildProjects(Project.NameKey parent) throws PermissionBackendException {
        HashMap<Project.NameKey, Project> children = new HashMap<Project.NameKey, Project>();
        for (Project.NameKey name : this.projectCache.all()) {
            ProjectState c = this.projectCache.get(name);
            if (c == null || !parent.equals(c.getProject().getParent(this.allProjects))) continue;
            children.put(c.getNameKey(), c.getProject());
        }
        return this.permissionBackend.user(this.user).filter(ProjectPermission.ACCESS, children.keySet()).stream().sorted().map(p -> this.json.format((Project)children.get(p))).collect(Collectors.toList());
    }

    private List<ProjectInfo> recursiveChildProjects(Project.NameKey parent) throws PermissionBackendException {
        Map<Project.NameKey, Project> projects = this.readAllProjects();
        Multimap<Project.NameKey, Project.NameKey> children = this.parentToChildren(projects);
        PermissionBackend.WithUser perm = this.permissionBackend.user(this.user);
        ArrayList<ProjectInfo> results = new ArrayList<ProjectInfo>();
        this.depthFirstFormat(results, perm, projects, children, parent);
        return results;
    }

    private Map<Project.NameKey, Project> readAllProjects() {
        HashMap<Project.NameKey, Project> projects = new HashMap<Project.NameKey, Project>();
        for (Project.NameKey name : this.projectCache.all()) {
            ProjectState c = this.projectCache.get(name);
            if (c == null) continue;
            projects.put(c.getNameKey(), c.getProject());
        }
        return projects;
    }

    private Multimap<Project.NameKey, Project.NameKey> parentToChildren(Map<Project.NameKey, Project> projects) {
        ArrayListMultimap<Project.NameKey, Project.NameKey> m = ArrayListMultimap.create();
        for (Map.Entry<Project.NameKey, Project> e : projects.entrySet()) {
            if (this.allProjects.equals(e.getKey())) continue;
            m.put(e.getValue().getParent(this.allProjects), e.getKey());
        }
        return m;
    }

    private void depthFirstFormat(List<ProjectInfo> results, PermissionBackend.WithUser perm, Map<Project.NameKey, Project> projects, Multimap<Project.NameKey, Project.NameKey> children, Project.NameKey parent) throws PermissionBackendException {
        List canSee = perm.filter(ProjectPermission.ACCESS, children.get(parent)).stream().sorted().collect(Collectors.toList());
        children.removeAll(parent);
        for (Project.NameKey c : canSee) {
            results.add(this.json.format(projects.get(c)));
            this.depthFirstFormat(results, perm, projects, children, c);
        }
    }
}

