/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.project;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.gerrit.common.data.AccessSection;
import com.google.gerrit.common.data.GlobalCapability;
import com.google.gerrit.common.data.GroupDescription;
import com.google.gerrit.common.data.GroupReference;
import com.google.gerrit.common.data.Permission;
import com.google.gerrit.common.data.PermissionRule;
import com.google.gerrit.common.errors.InvalidNameException;
import com.google.gerrit.extensions.api.access.AccessSectionInfo;
import com.google.gerrit.extensions.api.access.PermissionInfo;
import com.google.gerrit.extensions.api.access.PermissionRuleInfo;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.BadRequestException;
import com.google.gerrit.extensions.restapi.ResourceConflictException;
import com.google.gerrit.extensions.restapi.UnprocessableEntityException;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.config.AllProjectsName;
import com.google.gerrit.server.git.ProjectConfig;
import com.google.gerrit.server.group.GroupsCollection;
import com.google.gerrit.server.permissions.PermissionBackendException;
import com.google.gerrit.server.project.GetAccess;
import com.google.gerrit.server.project.RefPattern;
import com.google.gerrit.server.project.SetParent;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

@Singleton
public class SetAccessUtil {
    private final GroupsCollection groupsCollection;
    private final AllProjectsName allProjects;
    private final Provider<SetParent> setParent;

    @Inject
    private SetAccessUtil(GroupsCollection groupsCollection, AllProjectsName allProjects, Provider<SetParent> setParent) {
        this.groupsCollection = groupsCollection;
        this.allProjects = allProjects;
        this.setParent = setParent;
    }

    List<AccessSection> getAccessSections(Map<String, AccessSectionInfo> sectionInfos) throws UnprocessableEntityException {
        if (sectionInfos == null) {
            return Collections.emptyList();
        }
        ArrayList<AccessSection> sections = new ArrayList<AccessSection>(sectionInfos.size());
        for (Map.Entry<String, AccessSectionInfo> entry : sectionInfos.entrySet()) {
            if (entry.getValue().permissions == null) continue;
            AccessSection accessSection = new AccessSection(entry.getKey());
            for (Map.Entry<String, PermissionInfo> permissionEntry : entry.getValue().permissions.entrySet()) {
                if (permissionEntry.getValue().rules == null) continue;
                Permission p = new Permission(permissionEntry.getKey());
                if (permissionEntry.getValue().exclusive != null) {
                    p.setExclusiveGroup(permissionEntry.getValue().exclusive);
                }
                for (Map.Entry<String, PermissionRuleInfo> permissionRuleInfoEntry : permissionEntry.getValue().rules.entrySet()) {
                    GroupDescription.Basic group = this.groupsCollection.parseId(permissionRuleInfoEntry.getKey());
                    if (group == null) {
                        throw new UnprocessableEntityException(permissionRuleInfoEntry.getKey() + " is not a valid group ID");
                    }
                    PermissionRuleInfo pri = permissionRuleInfoEntry.getValue();
                    PermissionRule r = new PermissionRule(GroupReference.forGroup(group));
                    if (pri != null) {
                        if (pri.max != null) {
                            r.setMax(pri.max);
                        }
                        if (pri.min != null) {
                            r.setMin(pri.min);
                        }
                        if (pri.action != null) {
                            r.setAction((PermissionRule.Action)((Object)((ImmutableMap)((Object)GetAccess.ACTION_TYPE.inverse())).get((Object)pri.action)));
                        }
                        if (pri.force != null) {
                            r.setForce(pri.force);
                        }
                    }
                    p.add(r);
                }
                accessSection.getPermissions().add(p);
            }
            sections.add(accessSection);
        }
        return sections;
    }

    void validateChanges(ProjectConfig config, List<AccessSection> removals, List<AccessSection> additions) throws BadRequestException, InvalidNameException {
        for (AccessSection section : Iterables.concat(additions, removals)) {
            boolean isGlobalCapabilities = "GLOBAL_CAPABILITIES".equals(section.getName());
            if (!isGlobalCapabilities || this.allProjects.equals(config.getName())) continue;
            throw new BadRequestException("Cannot edit global capabilities for projects other than " + this.allProjects.get());
        }
        for (AccessSection section : additions) {
            String name = section.getName();
            boolean isGlobalCapabilities = "GLOBAL_CAPABILITIES".equals(name);
            if (!isGlobalCapabilities) {
                if (!AccessSection.isValid(name)) {
                    throw new BadRequestException("invalid section name");
                }
                RefPattern.validate(name);
                continue;
            }
            for (Permission p : section.getPermissions()) {
                if (GlobalCapability.isCapability(p.getName())) continue;
                throw new BadRequestException("Cannot add non-global capability " + p.getName() + " to global capabilities");
            }
        }
    }

    void applyChanges(ProjectConfig config, List<AccessSection> removals, List<AccessSection> additions) {
        for (AccessSection section : removals) {
            if (section.getPermissions().isEmpty()) {
                config.remove(config.getAccessSection(section.getName()));
                continue;
            }
            for (Permission p : section.getPermissions()) {
                if (p.getRules().isEmpty()) {
                    config.remove(config.getAccessSection(section.getName()), p);
                    continue;
                }
                for (PermissionRule r : p.getRules()) {
                    config.remove(config.getAccessSection(section.getName()), p, r);
                }
            }
        }
        for (AccessSection section : additions) {
            AccessSection currentAccessSection = config.getAccessSection(section.getName());
            if (currentAccessSection == null) {
                config.replace(section);
                continue;
            }
            for (Permission p : section.getPermissions()) {
                Permission currentPermission = currentAccessSection.getPermission(p.getName());
                if (currentPermission == null) {
                    currentAccessSection.addPermission(p);
                    continue;
                }
                for (PermissionRule r : p.getRules()) {
                    currentPermission.add(r);
                }
            }
        }
    }

    void setParentName(IdentifiedUser identifiedUser, ProjectConfig config, Project.NameKey projectName, Project.NameKey newParentProjectName, boolean checkAdmin) throws ResourceConflictException, AuthException, PermissionBackendException {
        if (newParentProjectName != null && !config.getProject().getNameKey().equals(this.allProjects) && !config.getProject().getParent(this.allProjects).equals(newParentProjectName)) {
            try {
                this.setParent.get().validateParentUpdate(projectName, identifiedUser, newParentProjectName.get(), checkAdmin);
            }
            catch (UnprocessableEntityException e) {
                throw new ResourceConflictException(e.getMessage(), e);
            }
            config.getProject().setParentName(newParentProjectName);
        }
    }
}

