/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.schema;

import com.google.gerrit.server.config.ConfigSection;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.schema.BaseDataSourceType;
import com.google.gerrit.server.schema.JdbcUtil;
import com.google.gerrit.server.schema.ScriptRunner;
import com.google.inject.Inject;
import java.io.IOException;
import org.eclipse.jgit.lib.Config;

class MaxDb
extends BaseDataSourceType {
    private Config cfg;

    @Inject
    MaxDb(@GerritServerConfig Config cfg) {
        super("com.sap.dbtech.jdbc.DriverSapDB");
        this.cfg = cfg;
    }

    @Override
    public String getUrl() {
        StringBuilder b = new StringBuilder();
        ConfigSection dbs = new ConfigSection(this.cfg, "database");
        b.append("jdbc:sapdb://");
        b.append(JdbcUtil.hostname(dbs.optional("hostname")));
        b.append("/");
        b.append(dbs.required("database"));
        return b.toString();
    }

    @Override
    public ScriptRunner getIndexScript() throws IOException {
        return MaxDb.getScriptRunner("index_maxdb.sql");
    }
}

