/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.schema;

import com.google.gerrit.server.config.ConfigSection;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.schema.BaseDataSourceType;
import com.google.gerrit.server.schema.JdbcUtil;
import com.google.inject.Inject;
import org.eclipse.jgit.lib.Config;

public class Oracle
extends BaseDataSourceType {
    private Config cfg;

    @Inject
    public Oracle(@GerritServerConfig Config cfg) {
        super("oracle.jdbc.driver.OracleDriver");
        this.cfg = cfg;
    }

    @Override
    public String getUrl() {
        StringBuilder b = new StringBuilder();
        ConfigSection dbc = new ConfigSection(this.cfg, "database");
        b.append("jdbc:oracle:thin:@");
        b.append(JdbcUtil.hostname(dbc.optional("hostname")));
        b.append(JdbcUtil.port(dbc.optional("port")));
        b.append(":");
        b.append(dbc.required("instance"));
        return b.toString();
    }

    @Override
    public String getValidationQuery() {
        return "select 1 from dual";
    }
}

